/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.api;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.io.Retainable;

public interface Stream {
    public long getId();

    public Session getSession();

    public CompletableFuture<Stream> data(DataFrame var1);

    public Data readData();

    public void demand();

    public CompletableFuture<Stream> trailer(HeadersFrame var1);

    public void reset(long var1, Throwable var3);

    public static abstract class Data
    implements Retainable {
        private final DataFrame frame;

        public Data(DataFrame frame) {
            this.frame = Objects.requireNonNull(frame);
        }

        public ByteBuffer getByteBuffer() {
            return this.frame.getByteBuffer();
        }

        public boolean isLast() {
            return this.frame.isLast();
        }

        public String toString() {
            return String.format("%s[%s]", this.getClass().getSimpleName(), this.frame);
        }
    }

    public static interface Server
    extends Stream {
        public CompletableFuture<Stream> respond(HeadersFrame var1);

        public static interface Listener {
            default public void onDataAvailable(Server stream) {
            }

            default public void onTrailer(Server stream, HeadersFrame frame) {
            }

            default public boolean onIdleTimeout(Server stream, Throwable failure) {
                return true;
            }

            default public void onFailure(Server stream, long error, Throwable failure) {
            }
        }
    }

    public static interface Client
    extends Stream {

        public static interface Listener {
            default public void onResponse(Client stream, HeadersFrame frame) {
            }

            default public void onDataAvailable(Client stream) {
            }

            default public void onTrailer(Client stream, HeadersFrame frame) {
            }

            default public boolean onIdleTimeout(Client stream, Throwable failure) {
                return true;
            }

            default public void onFailure(Client stream, long error, Throwable failure) {
            }
        }
    }
}

