/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.utils.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jetty.osgi.boot.utils.BundleClassLoaderHelper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.Bundle;

public class DefaultBundleClassLoaderHelper
implements BundleClassLoaderHelper {
    private static final Logger LOG = Log.getLogger(BundleClassLoaderHelper.class);
    private static OSGiContainerType osgiContainer;
    private static Class Equinox_BundleHost_Class;
    private static Class Equinox_EquinoxBundle_Class;
    private static Class Felix_BundleImpl_Class;
    private static Class Felix_BundleWiring_Class;
    private static Method Equinox_BundleHost_getBundleLoader_method;
    private static Method Equinox_BundleLoader_createClassLoader_method;
    private static Method Equinox_EquinoxBundle_getModuleClassLoader_Method;
    private static Method Felix_BundleImpl_Adapt_Method;
    private static Field Felix_BundleImpl_m_Modules_Field;
    private static Field Felix_ModuleImpl_m_ClassLoader_Field;
    private static Method Felix_BundleWiring_getClassLoader_Method;

    private static void checkContainerType(Bundle bundle) {
        if (osgiContainer != null) {
            return;
        }
        try {
            Equinox_BundleHost_Class = bundle.getClass().getClassLoader().loadClass("org.eclipse.osgi.framework.internal.core.BundleHost");
            osgiContainer = OSGiContainerType.EquinoxOld;
            return;
        }
        catch (ClassNotFoundException e) {
            LOG.ignore((Throwable)e);
            try {
                Equinox_EquinoxBundle_Class = bundle.getClass().getClassLoader().loadClass("org.eclipse.osgi.internal.framework.EquinoxBundle");
                osgiContainer = OSGiContainerType.EquinoxLuna;
                return;
            }
            catch (ClassNotFoundException e2) {
                LOG.ignore((Throwable)e2);
                try {
                    Felix_BundleImpl_Class = bundle.getClass().getClassLoader().loadClass("org.apache.felix.framework.BundleImpl");
                    try {
                        Felix_BundleImpl_Adapt_Method = Felix_BundleImpl_Class.getDeclaredMethod("adapt", Class.class);
                        osgiContainer = OSGiContainerType.Felix403;
                        return;
                    }
                    catch (NoSuchMethodException e3) {
                        osgiContainer = OSGiContainerType.FelixOld;
                        return;
                    }
                }
                catch (ClassNotFoundException e4) {
                    LOG.warn("Unknown OSGi container type", new Object[0]);
                    return;
                }
            }
        }
    }

    @Override
    public ClassLoader getBundleClassLoader(Bundle bundle) {
        String bundleActivator = (String)bundle.getHeaders().get("Bundle-Activator");
        if (bundleActivator == null) {
            bundleActivator = (String)bundle.getHeaders().get("Jetty-ClassInBundle");
        }
        if (bundleActivator != null) {
            try {
                return bundle.loadClass(bundleActivator).getClassLoader();
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Throwable)e);
            }
        }
        return this.getBundleClassLoaderForContainer(bundle);
    }

    private ClassLoader getBundleClassLoaderForContainer(Bundle bundle) {
        DefaultBundleClassLoaderHelper.checkContainerType(bundle);
        if (osgiContainer == null) {
            LOG.warn("No classloader for unknown OSGi container type", new Object[0]);
            return null;
        }
        switch (osgiContainer) {
            case EquinoxOld: 
            case EquinoxLuna: {
                return DefaultBundleClassLoaderHelper.internalGetEquinoxBundleClassLoader(bundle);
            }
            case FelixOld: 
            case Felix403: {
                return DefaultBundleClassLoaderHelper.internalGetFelixBundleClassLoader(bundle);
            }
        }
        LOG.warn("No classloader found for bundle " + bundle.getSymbolicName(), new Object[0]);
        return null;
    }

    private static ClassLoader internalGetEquinoxBundleClassLoader(Bundle bundle) {
        if (osgiContainer == OSGiContainerType.EquinoxOld) {
            try {
                if (Equinox_BundleHost_getBundleLoader_method == null) {
                    Equinox_BundleHost_getBundleLoader_method = Equinox_BundleHost_Class.getDeclaredMethod("getBundleLoader", new Class[0]);
                    Equinox_BundleHost_getBundleLoader_method.setAccessible(true);
                }
                Object bundleLoader = Equinox_BundleHost_getBundleLoader_method.invoke((Object)bundle, new Object[0]);
                if (Equinox_BundleLoader_createClassLoader_method == null && bundleLoader != null) {
                    Equinox_BundleLoader_createClassLoader_method = bundleLoader.getClass().getClassLoader().loadClass("org.eclipse.osgi.internal.loader.BundleLoader").getDeclaredMethod("createClassLoader", new Class[0]);
                    Equinox_BundleLoader_createClassLoader_method.setAccessible(true);
                }
                return (ClassLoader)Equinox_BundleLoader_createClassLoader_method.invoke(bundleLoader, new Object[0]);
            }
            catch (ClassNotFoundException t) {
                LOG.warn((Throwable)t);
                return null;
            }
            catch (Throwable t) {
                LOG.warn(t);
                return null;
            }
        }
        if (osgiContainer == OSGiContainerType.EquinoxLuna) {
            try {
                if (Equinox_EquinoxBundle_getModuleClassLoader_Method == null) {
                    Equinox_EquinoxBundle_getModuleClassLoader_Method = Equinox_EquinoxBundle_Class.getDeclaredMethod("getModuleClassLoader", Boolean.TYPE);
                }
                Equinox_EquinoxBundle_getModuleClassLoader_Method.setAccessible(true);
                return (ClassLoader)Equinox_EquinoxBundle_getModuleClassLoader_Method.invoke((Object)bundle, Boolean.FALSE);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }
        LOG.warn("No classloader for equinox platform for bundle " + bundle.getSymbolicName(), new Object[0]);
        return null;
    }

    /*
     * Loose catch block
     */
    private static ClassLoader internalGetFelixBundleClassLoader(Bundle bundle) {
        if (osgiContainer == OSGiContainerType.Felix403) {
            try {
                if (Felix_BundleWiring_Class == null) {
                    Felix_BundleWiring_Class = bundle.getClass().getClassLoader().loadClass("org.osgi.framework.wiring.BundleWiring");
                }
                Felix_BundleImpl_Adapt_Method.setAccessible(true);
                if (Felix_BundleWiring_getClassLoader_Method == null) {
                    Felix_BundleWiring_getClassLoader_Method = Felix_BundleWiring_Class.getDeclaredMethod("getClassLoader", new Class[0]);
                    Felix_BundleWiring_getClassLoader_Method.setAccessible(true);
                }
                Object wiring = Felix_BundleImpl_Adapt_Method.invoke((Object)bundle, Felix_BundleWiring_Class);
                return (ClassLoader)Felix_BundleWiring_getClassLoader_Method.invoke(wiring, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }
        if (osgiContainer == OSGiContainerType.FelixOld) {
            Object currentModuleImpl;
            if (Felix_BundleImpl_m_Modules_Field == null) {
                Felix_BundleImpl_m_Modules_Field = Felix_BundleImpl_Class.getDeclaredField("m_modules");
                Felix_BundleImpl_m_Modules_Field.setAccessible(true);
            }
            try {
                Object[] moduleArray = (Object[])Felix_BundleImpl_m_Modules_Field.get(bundle);
                currentModuleImpl = moduleArray[moduleArray.length - 1];
            }
            catch (Throwable t2) {
                try {
                    List moduleArray = (List)Felix_BundleImpl_m_Modules_Field.get(bundle);
                    currentModuleImpl = moduleArray.get(moduleArray.size() - 1);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    return null;
                }
            }
            if (Felix_ModuleImpl_m_ClassLoader_Field == null && currentModuleImpl != null) {
                try {
                    Felix_ModuleImpl_m_ClassLoader_Field = bundle.getClass().getClassLoader().loadClass("org.apache.felix.framework.ModuleImpl").getDeclaredField("m_classLoader");
                    Felix_ModuleImpl_m_ClassLoader_Field.setAccessible(true);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    return null;
                }
            }
            ClassLoader cl = null;
            try {
                cl = (ClassLoader)Felix_ModuleImpl_m_ClassLoader_Field.get(currentModuleImpl);
                if (cl != null) {
                    return cl;
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return null;
            }
            {
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    return null;
                }
            }
            try {
                bundle.loadClass("java.lang.Object");
                cl = (ClassLoader)Felix_ModuleImpl_m_ClassLoader_Field.get(currentModuleImpl);
                return cl;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }
        LOG.warn("No classloader for felix platform for bundle " + bundle.getSymbolicName(), new Object[0]);
        return null;
    }

    private static enum OSGiContainerType {
        EquinoxOld,
        EquinoxLuna,
        FelixOld,
        Felix403;

    }
}

