/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.issues;

import org.apache.commons.text.WordUtils;
import org.eclipse.jetty.toolchain.version.issues.IssueSyntax;

public class Issue {
    private IssueSyntax syntax;
    private String id;
    private String text;
    private int wrapColumn = 76;

    public Issue(String id) {
        this.id = id;
    }

    public Issue(String id, String subject, IssueSyntax syntax) {
        this.id = id;
        this.text = subject;
        this.syntax = syntax;
    }

    public void appendText(String line) {
        this.text = (line = line.trim()).charAt(0) == '*' ? this.text + "\n   " + line : this.text + " " + line;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Issue other = (Issue)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public IssueSyntax getSyntax() {
        return this.syntax;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        StringBuilder line = new StringBuilder();
        line.append(" + ");
        if (this.syntax == IssueSyntax.BAD) {
            line.append(WordUtils.wrap((String)this.text, (int)this.wrapColumn, (String)"\n   ", (boolean)false));
        } else {
            line.append(WordUtils.wrap((String)(this.id + " " + this.text), (int)this.wrapColumn, (String)"\n   ", (boolean)false));
        }
        return line.toString();
    }
}

