/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.messages;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.common.message.MessageAppender;
import org.eclipse.jetty.websocket.jsr356.endpoints.JsrAnnotatedEventDriver;

public class TextPartialOnMessage
implements MessageAppender {
    private final JsrAnnotatedEventDriver driver;
    private boolean finished;

    public TextPartialOnMessage(JsrAnnotatedEventDriver driver) {
        this.driver = driver;
        this.finished = false;
    }

    public void appendMessage(ByteBuffer payload, boolean isLast) throws IOException {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        if (payload == null) {
            this.driver.onPartialTextMessage("", isLast);
        } else {
            String text = BufferUtil.toUTF8String((ByteBuffer)payload);
            this.driver.onPartialTextMessage(text, isLast);
        }
    }

    public void messageComplete() {
        this.finished = true;
    }
}

