/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.websocket.jsr356.metadata.CoderMetadata;

public abstract class CoderMetadataSet<T, M extends CoderMetadata<T>>
implements Iterable<M> {
    private final List<M> metadatas = new ArrayList<M>();
    private final List<Class<? extends T>> coders = new ArrayList<Class<? extends T>>();
    private final Map<Class<?>, Integer> typeMap = new ConcurrentHashMap();
    private final Map<Class<? extends T>, List<Integer>> implMap = new ConcurrentHashMap<Class<? extends T>, List<Integer>>();

    protected CoderMetadataSet() {
    }

    public void add(Class<? extends T> coder) {
        List<M> metadatas = this.discover(coder);
        this.trackMetadata((M)metadatas);
    }

    public List<M> addAll(Class<? extends T>[] coders) {
        ArrayList<M> metadatas = new ArrayList<M>();
        for (Class<? extends T> coder : coders) {
            metadatas.addAll(this.discover(coder));
        }
        this.trackMetadata((M)metadatas);
        return metadatas;
    }

    public List<M> addAll(List<Class<? extends T>> coders) {
        ArrayList<M> metadatas = new ArrayList<M>();
        for (Class<T> clazz : coders) {
            metadatas.addAll(this.discover(clazz));
        }
        this.trackMetadata((M)metadatas);
        return metadatas;
    }

    protected abstract List<M> discover(Class<? extends T> var1);

    public Class<? extends T> getCoder(Class<?> type) {
        M metadata = this.getMetadataByType(type);
        if (metadata == null) {
            return null;
        }
        return ((CoderMetadata)metadata).getCoderClass();
    }

    public List<Class<? extends T>> getList() {
        return this.coders;
    }

    public List<M> getMetadataByImplementation(Class<? extends T> clazz) {
        List<Integer> indexes = this.implMap.get(clazz);
        if (indexes == null) {
            return null;
        }
        ArrayList<M> ret = new ArrayList<M>();
        for (Integer idx : indexes) {
            ret.add(this.metadatas.get(idx));
        }
        return ret;
    }

    public M getMetadataByType(Class<?> type) {
        Integer idx = this.typeMap.get(type);
        if (idx == null) {
            return null;
        }
        return (M)((CoderMetadata)this.metadatas.get(idx));
    }

    @Override
    public Iterator<M> iterator() {
        return this.metadatas.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("[metadatas=");
        builder.append(this.metadatas.size());
        builder.append(",coders=");
        builder.append(this.coders.size());
        builder.append("]");
        return builder.toString();
    }

    protected void trackMetadata(List<M> metadatas) {
        for (CoderMetadata metadata : metadatas) {
            this.trackMetadata(metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackMetadata(M metadata) {
        List<M> list = this.metadatas;
        synchronized (list) {
            Class<?> type;
            boolean duplicate = false;
            if (this.metadatas.contains(metadata)) {
                duplicate = true;
            }
            if (this.typeMap.containsKey(type = ((CoderMetadata)metadata).getObjectType())) {
                duplicate = true;
            }
            if (duplicate) {
                StringBuilder err = new StringBuilder();
                err.append("Duplicate decoder for type: ");
                err.append(type);
                err.append(" (class ").append(((CoderMetadata)metadata).getCoderClass().getName());
                M dup = this.getMetadataByType(type);
                err.append(" duplicates ");
                err.append(((CoderMetadata)dup).getCoderClass().getName());
                err.append(")");
                throw new IllegalStateException(err.toString());
            }
            Class coderClass = ((CoderMetadata)metadata).getCoderClass();
            int newidx = this.metadatas.size();
            this.metadatas.add(metadata);
            this.coders.add(coderClass);
            this.typeMap.put(type, newidx);
            List<Integer> indexes = this.implMap.get(coderClass);
            if (indexes == null) {
                indexes = new ArrayList<Integer>();
            }
            if (indexes.contains(newidx)) {
                // empty if block
            }
            indexes.add(newidx);
            this.implMap.put(coderClass, indexes);
        }
    }
}

