/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.annotations;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.common.events.annotated.InvalidSignatureException;
import org.eclipse.jetty.websocket.jsr356.annotations.IJsrParamId;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrParamIdOnMessage;
import org.eclipse.jetty.websocket.jsr356.annotations.Param;
import org.eclipse.jetty.websocket.jsr356.decoders.ByteArrayDecoder;
import org.eclipse.jetty.websocket.jsr356.decoders.ByteBufferDecoder;

public class JsrParamIdBinary
extends JsrParamIdOnMessage
implements IJsrParamId {
    public static final IJsrParamId INSTANCE = new JsrParamIdBinary();

    @Override
    public boolean process(Param param, JsrCallable callable) throws InvalidSignatureException {
        if (super.process(param, callable)) {
            return true;
        }
        if (param.type.isAssignableFrom(ByteBuffer.class)) {
            param.bind(Param.Role.MESSAGE_BINARY);
            callable.setDecoderClass(ByteBufferDecoder.class);
            return true;
        }
        if (param.type.isAssignableFrom(byte[].class)) {
            param.bind(Param.Role.MESSAGE_BINARY);
            callable.setDecoderClass(ByteArrayDecoder.class);
            return true;
        }
        if (param.type.isAssignableFrom(InputStream.class)) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_BINARY_STREAM);
            return true;
        }
        return false;
    }
}

