/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server;

import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.DiscoveredEndpoints;
import org.eclipse.jetty.websocket.jsr356.server.deploy.ServerEndpointAnnotationHandler;
import org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;

public class WebSocketConfiguration
extends AbstractConfiguration {
    public static final String ENABLE = "org.eclipse.jetty.websocket.jsr356";
    private static final Logger LOG = Log.getLogger(WebSocketConfiguration.class);

    public static ServerContainer configureContext(ServletContextHandler context) {
        LOG.debug("Configure javax.websocket for WebApp {}", new Object[]{context});
        WebSocketUpgradeFilter filter = WebSocketUpgradeFilter.configureContext((ServletContextHandler)context);
        ServerContainer jettyContainer = new ServerContainer((MappedWebSocketCreator)filter, filter.getFactory());
        context.addBean((Object)jettyContainer);
        context.setAttribute(javax.websocket.server.ServerContainer.class.getName(), (Object)jettyContainer);
        context.setAttribute(DiscoveredEndpoints.class.getName(), (Object)new DiscoveredEndpoints());
        return jettyContainer;
    }

    public static boolean isJSR356Context(WebAppContext context) {
        Object enable = context.getAttribute(ENABLE);
        if (enable instanceof Boolean) {
            return (Boolean)enable;
        }
        enable = context.getServer().getAttribute(ENABLE);
        if (enable instanceof Boolean) {
            return (Boolean)enable;
        }
        return true;
    }

    public void configure(WebAppContext context) throws Exception {
        if (WebSocketConfiguration.isJSR356Context(context)) {
            WebSocketConfiguration.configureContext((ServletContextHandler)context);
        } else {
            LOG.debug("JSR-356 support disabled for WebApp {}", new Object[]{context});
        }
    }

    public void preConfigure(WebAppContext context) throws Exception {
        if (WebSocketConfiguration.isJSR356Context(context)) {
            boolean scanningAdded = false;
            for (Configuration config : context.getConfigurations()) {
                if (!(config instanceof AnnotationConfiguration)) continue;
                AnnotationConfiguration annocfg = (AnnotationConfiguration)config;
                annocfg.addDiscoverableAnnotationHandler((AnnotationParser.DiscoverableAnnotationHandler)new ServerEndpointAnnotationHandler(context));
                scanningAdded = true;
            }
            LOG.debug("@ServerEndpoint scanning added: {}", new Object[]{scanningAdded});
        }
    }
}

