/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server.deploy;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.WebSocketConfiguration;
import org.eclipse.jetty.websocket.jsr356.server.deploy.DiscoveredEndpoints;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;

@HandlesTypes(value={ServerApplicationConfig.class, Endpoint.class})
public class ServerApplicationConfigListener
implements ServletContainerInitializer {
    private static final Logger LOG = Log.getLogger(ServerApplicationConfigListener.class);

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        if (!WebSocketConfiguration.isJSR356Context(WebAppContext.getCurrentWebAppContext())) {
            return;
        }
        WebSocketUpgradeFilter filter = (WebSocketUpgradeFilter)ctx.getAttribute(WebSocketUpgradeFilter.class.getName());
        if (filter == null) {
            LOG.warn("Required attribute not available: " + WebSocketUpgradeFilter.class.getName(), new Object[0]);
            return;
        }
        DiscoveredEndpoints discovered = (DiscoveredEndpoints)ctx.getAttribute(DiscoveredEndpoints.class.getName());
        if (discovered == null) {
            LOG.warn("Required attribute not available: " + DiscoveredEndpoints.class.getName(), new Object[0]);
            return;
        }
        LOG.debug("Found {} classes", (long)c.size());
        LOG.debug("Discovered: {}", new Object[]{discovered});
        this.addEndpoints(c, discovered);
        ServerContainer container = (ServerContainer)((Object)ctx.getAttribute(javax.websocket.server.ServerContainer.class.getName()));
        HashSet<Class<? extends Endpoint>> archiveSpecificExtendEndpoints = new HashSet<Class<? extends Endpoint>>();
        HashSet archiveSpecificAnnotatedEndpoints = new HashSet();
        List<Class<? extends ServerApplicationConfig>> serverAppConfigs = this.filterServerApplicationConfigs(c);
        if (serverAppConfigs.size() >= 1) {
            for (Class<? extends ServerApplicationConfig> clazz : this.filterServerApplicationConfigs(c)) {
                LOG.debug("Found ServerApplicationConfig: {}", new Object[]{clazz});
                try {
                    Set annotatedClasses;
                    ServerApplicationConfig config = clazz.newInstance();
                    URI archiveURI = DiscoveredEndpoints.getArchiveURI(clazz);
                    archiveSpecificExtendEndpoints.clear();
                    archiveSpecificAnnotatedEndpoints.clear();
                    discovered.getArchiveSpecificExtendedEndpoints(archiveURI, archiveSpecificExtendEndpoints);
                    discovered.getArchiveSpecificAnnnotatedEndpoints(archiveURI, archiveSpecificAnnotatedEndpoints);
                    Set seconfigs = config.getEndpointConfigs(archiveSpecificExtendEndpoints);
                    if (seconfigs != null) {
                        for (ServerEndpointConfig sec : seconfigs) {
                            container.addEndpoint(sec);
                        }
                    }
                    if ((annotatedClasses = config.getAnnotatedEndpointClasses(archiveSpecificAnnotatedEndpoints)) == null) continue;
                    for (Class annotatedClass : annotatedClasses) {
                        container.addEndpoint(annotatedClass);
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ServletException("Unable to instantiate: " + clazz.getName(), (Throwable)e);
                }
                catch (DeploymentException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        } else {
            for (Class<?> annotatedClass : discovered.getAnnotatedEndpoints()) {
                try {
                    container.addEndpoint(annotatedClass);
                }
                catch (DeploymentException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }
    }

    private List<Class<? extends ServerApplicationConfig>> filterServerApplicationConfigs(Set<Class<?>> c) {
        ArrayList<Class<? extends ServerApplicationConfig>> configs = new ArrayList<Class<? extends ServerApplicationConfig>>();
        for (Class<?> clazz : c) {
            if (!ServerApplicationConfig.class.isAssignableFrom(clazz)) continue;
            configs.add(clazz);
        }
        return configs;
    }

    private void addEndpoints(Set<Class<?>> c, DiscoveredEndpoints discovered) {
        for (Class<?> clazz : c) {
            if (!Endpoint.class.isAssignableFrom(clazz)) continue;
            discovered.addExtendedEndpoint(clazz);
        }
    }
}

