/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server.deploy;

import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.deploy.DiscoveredEndpoints;

public class ServerEndpointAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = Log.getLogger(ServerEndpointAnnotation.class);

    public ServerEndpointAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public ServerEndpointAnnotation(WebAppContext context, String className, Resource resource) {
        super(context, className, resource);
    }

    public void apply() {
        Class clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn(this._className + " cannot be loaded", new Object[0]);
            return;
        }
        DiscoveredEndpoints discovered = (DiscoveredEndpoints)this._context.getAttribute(DiscoveredEndpoints.class.getName());
        if (discovered == null) {
            LOG.warn("Context attribute not found: " + DiscoveredEndpoints.class.getName(), new Object[0]);
            return;
        }
        discovered.addAnnotatedEndpoint(clazz);
    }
}

