/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server.deploy;

import java.util.List;
import org.eclipse.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.deploy.ServerEndpointAnnotation;

public class ServerEndpointAnnotationHandler
extends AbstractDiscoverableAnnotationHandler {
    private static final String ANNOTATION_NAME = "javax.websocket.server.ServerEndpoint";
    private static final Logger LOG = Log.getLogger(ServerEndpointAnnotationHandler.class);

    public ServerEndpointAnnotationHandler(WebAppContext context) {
        super(context);
    }

    public ServerEndpointAnnotationHandler(WebAppContext context, List<DiscoveredAnnotation> list) {
        super(context, list);
    }

    public String getAnnotationName() {
        return ANNOTATION_NAME;
    }

    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotationName, List<AnnotationParser.Value> values) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("handleClass: {}, {}, {}", new Object[]{className, annotationName, values});
        }
        if (!ANNOTATION_NAME.equals(annotationName)) {
            return;
        }
        ServerEndpointAnnotation annotation = new ServerEndpointAnnotation(this._context, className, this._resource);
        this.addAnnotation(annotation);
    }

    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
    }

    public void handleMethod(String className, String methodName, int access, String desc, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
    }
}

