/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.function.Consumer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.websocket.api.WebSocketContainer;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.server.ServerWebSocketContainer;

public class WebSocketUpgradeHandler
extends Handler.Wrapper {
    private final ServerWebSocketContainer _container;

    public static WebSocketUpgradeHandler from(Server server, ContextHandler context) {
        WebSocketComponents components = WebSocketServerComponents.ensureWebSocketComponents((Server)server, (ContextHandler)context);
        WebSocketMappings mappings = new WebSocketMappings(components);
        ServerWebSocketContainer container = new ServerWebSocketContainer(mappings);
        WebSocketUpgradeHandler wsHandler = new WebSocketUpgradeHandler(container);
        context.getContext().setAttribute(WebSocketContainer.class.getName(), (Object)wsHandler._container);
        return wsHandler;
    }

    public WebSocketUpgradeHandler(ServerWebSocketContainer container) {
        this._container = container;
        this.addBean((Object)container);
    }

    public WebSocketUpgradeHandler configure(Consumer<ServerWebSocketContainer> configurator) {
        configurator.accept(this._container);
        return this;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (this.handle(this._container, request, response, callback)) {
            return true;
        }
        return super.handle(request, response, callback);
    }

    protected boolean handle(ServerWebSocketContainer container, Request request, Response response, Callback callback) {
        try {
            return container.handle(request, response, callback);
        }
        catch (Throwable x) {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (Throwable)x);
            return true;
        }
    }

    public Invocable.InvocationType getInvocationType() {
        if (this.isDynamic()) {
            return Invocable.InvocationType.BLOCKING;
        }
        Handler handler = this.getHandler();
        Invocable.InvocationType handlerInvocationType = handler == null ? Invocable.InvocationType.NON_BLOCKING : handler.getInvocationType();
        return Invocable.combine((Invocable.InvocationType)handlerInvocationType, (Invocable.InvocationType)this._container.getInvocationType());
    }
}

