/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.common.extensions.compress;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.client.common.OpCode;
import org.eclipse.jetty.websocket.client.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.client.common.extensions.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.client.common.frames.DataFrame;

public abstract class CompressExtension
extends AbstractExtension {
    protected static final byte[] TAIL_BYTES = new byte[]{0, 0, -1, -1};
    protected static final ByteBuffer TAIL_BYTES_BUF = ByteBuffer.wrap(TAIL_BYTES);
    private static final Logger LOG = Log.getLogger(CompressExtension.class);
    protected static final int TAIL_DROP_NEVER = 0;
    protected static final int TAIL_DROP_ALWAYS = 1;
    protected static final int TAIL_DROP_FIN_ONLY = 2;
    protected static final int RSV_USE_ALWAYS = 0;
    protected static final int RSV_USE_ONLY_FIRST = 1;
    protected static final int INFLATE_BUFFER_SIZE = 8192;
    protected static final int INPUT_MAX_BUFFER_SIZE = 8192;
    private static final int DECOMPRESS_BUF_SIZE = 8192;
    private static final boolean NOWRAP = true;
    private final Queue<FrameEntry> entries = new ConcurrentArrayQueue();
    private final IteratingCallback flusher = new Flusher();
    private final Deflater deflater;
    private final Inflater inflater;
    protected AtomicInteger decompressCount = new AtomicInteger(0);
    private int tailDrop = 0;
    private int rsvUse = 0;

    protected CompressExtension() {
        this.deflater = new Deflater(-1, true);
        this.inflater = new Inflater(true);
        this.tailDrop = this.getTailDropMode();
        this.rsvUse = this.getRsvUseMode();
    }

    public Deflater getDeflater() {
        return this.deflater;
    }

    public Inflater getInflater() {
        return this.inflater;
    }

    @Override
    public boolean isRsv1User() {
        return true;
    }

    abstract int getTailDropMode();

    abstract int getRsvUseMode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardIncoming(Frame frame, ByteAccumulator accumulator) {
        DataFrame newFrame = new DataFrame(frame);
        newFrame.setRsv1(false);
        ByteBuffer buffer = this.getBufferPool().acquire(accumulator.getLength(), false);
        try {
            BufferUtil.flipToFill((ByteBuffer)buffer);
            accumulator.transferTo(buffer);
            newFrame.setPayload(buffer);
            this.nextIncomingFrame(newFrame);
        }
        finally {
            this.getBufferPool().release(buffer);
        }
    }

    protected ByteAccumulator newByteAccumulator() {
        int maxSize = Math.max(this.getPolicy().getMaxTextMessageSize(), this.getPolicy().getMaxBinaryMessageBufferSize());
        return new ByteAccumulator(maxSize);
    }

    protected void decompress(ByteAccumulator accumulator, ByteBuffer buf) throws DataFormatException {
        if (buf == null || !buf.hasRemaining()) {
            return;
        }
        byte[] output = new byte[8192];
        if (this.inflater.needsInput() && !CompressExtension.supplyInput(this.inflater, buf)) {
            LOG.debug("Needed input, but no buffer could supply input", new Object[0]);
            return;
        }
        int read = 0;
        while ((read = this.inflater.inflate(output)) >= 0) {
            if (read == 0) {
                LOG.debug("Decompress: read 0 {}", new Object[]{CompressExtension.toDetail(this.inflater)});
                break;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Decompressed {} bytes: {}", new Object[]{read, CompressExtension.toDetail(this.inflater)});
            }
            accumulator.copyChunk(output, 0, read);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decompress: exiting {}", new Object[]{CompressExtension.toDetail(this.inflater)});
        }
    }

    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (this.flusher.isFailed()) {
            this.notifyCallbackFailure(callback, new ZipException());
            return;
        }
        FrameEntry entry = new FrameEntry(frame, callback, batchMode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing {}", new Object[]{entry});
        }
        this.entries.offer(entry);
        this.flusher.iterate();
    }

    protected void notifyCallbackSuccess(WriteCallback callback) {
        block3: {
            try {
                if (callback != null) {
                    callback.writeSuccess();
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying success of callback " + callback, x);
            }
        }
    }

    protected void notifyCallbackFailure(WriteCallback callback, Throwable failure) {
        block3: {
            try {
                if (callback != null) {
                    callback.writeFailed(failure);
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying failure of callback " + callback, x);
            }
        }
    }

    private static boolean supplyInput(Inflater inflater, ByteBuffer buf) {
        byte[] input;
        int len;
        if (buf.remaining() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No data left left to supply to Inflater", new Object[0]);
            }
            return false;
        }
        int inputOffset = 0;
        if (buf.hasArray()) {
            len = buf.remaining();
            input = buf.array();
            inputOffset = buf.position() + buf.arrayOffset();
            buf.position(buf.position() + len);
        } else {
            len = Math.min(8192, buf.remaining());
            input = new byte[len];
            inputOffset = 0;
            buf.get(input, 0, len);
        }
        inflater.setInput(input, inputOffset, len);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supplied {} input bytes: {}", new Object[]{input.length, CompressExtension.toDetail(inflater)});
        }
        return true;
    }

    private static boolean supplyInput(Deflater deflater, ByteBuffer buf) {
        byte[] input;
        int len;
        if (buf.remaining() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No data left left to supply to Deflater", new Object[0]);
            }
            return false;
        }
        int inputOffset = 0;
        if (buf.hasArray()) {
            len = buf.remaining();
            input = buf.array();
            inputOffset = buf.position() + buf.arrayOffset();
            buf.position(buf.position() + len);
        } else {
            len = Math.min(8192, buf.remaining());
            input = new byte[len];
            inputOffset = 0;
            buf.get(input, 0, len);
        }
        deflater.setInput(input, inputOffset, len);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supplied {} input bytes: {}", new Object[]{input.length, CompressExtension.toDetail(deflater)});
        }
        return true;
    }

    private static String toDetail(Inflater inflater) {
        return String.format("Inflater[finished=%b,read=%d,written=%d,remaining=%d,in=%d,out=%d]", inflater.finished(), inflater.getBytesRead(), inflater.getBytesWritten(), inflater.getRemaining(), inflater.getTotalIn(), inflater.getTotalOut());
    }

    private static String toDetail(Deflater deflater) {
        return String.format("Deflater[finished=%b,read=%d,written=%d,in=%d,out=%d]", deflater.finished(), deflater.getBytesRead(), deflater.getBytesWritten(), deflater.getTotalIn(), deflater.getTotalOut());
    }

    public static boolean endsWithTail(ByteBuffer buf) {
        if (buf == null || buf.remaining() < TAIL_BYTES.length) {
            return false;
        }
        int limit = buf.limit();
        for (int i = TAIL_BYTES.length; i > 0; --i) {
            if (buf.get(limit - i) == TAIL_BYTES[TAIL_BYTES.length - i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private class Flusher
    extends IteratingCallback
    implements WriteCallback {
        private FrameEntry current;
        private boolean finished = true;

        private Flusher() {
        }

        public void failed(Throwable x) {
            LOG.warn(x);
            super.failed(x);
        }

        protected IteratingCallback.Action process() throws Exception {
            if (this.finished) {
                this.current = (FrameEntry)CompressExtension.this.entries.poll();
                LOG.debug("Processing {}", new Object[]{this.current});
                if (this.current == null) {
                    return IteratingCallback.Action.IDLE;
                }
                this.deflate(this.current);
            } else {
                this.compress(this.current, false);
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        private void deflate(FrameEntry entry) {
            Frame frame = entry.frame;
            BatchMode batchMode = entry.batchMode;
            if (OpCode.isControlFrame(frame.getOpCode()) || !frame.hasPayload()) {
                CompressExtension.this.nextOutgoingFrame(frame, this, batchMode);
                return;
            }
            this.compress(entry, true);
        }

        private void compress(FrameEntry entry, boolean first) {
            Frame frame = entry.frame;
            ByteBuffer data = frame.getPayload();
            int remaining = data.remaining();
            int outputLength = Math.max(256, data.remaining());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressing {}: {} bytes in {} bytes chunk", new Object[]{entry, remaining, outputLength});
            }
            boolean needsCompress = true;
            if (CompressExtension.this.deflater.needsInput() && !CompressExtension.supplyInput(CompressExtension.this.deflater, data)) {
                needsCompress = false;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] output = new byte[outputLength];
            boolean fin = frame.isFin();
            while (needsCompress) {
                int compressed = CompressExtension.this.deflater.deflate(output, 0, outputLength, 2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Wrote {} bytes to output buffer", (long)compressed);
                }
                out.write(output, 0, compressed);
                if (compressed >= outputLength) continue;
                needsCompress = false;
            }
            ByteBuffer payload = ByteBuffer.wrap(out.toByteArray());
            if (payload.remaining() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("compressed bytes[] = {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)payload)});
                }
                if (CompressExtension.this.tailDrop == 1) {
                    if (CompressExtension.endsWithTail(payload)) {
                        payload.limit(payload.limit() - TAIL_BYTES.length);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_ALWAYS) = {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)payload)});
                    }
                } else if (CompressExtension.this.tailDrop == 2) {
                    if (frame.isFin() && CompressExtension.endsWithTail(payload)) {
                        payload.limit(payload.limit() - TAIL_BYTES.length);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_FIN_ONLY) = {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)payload)});
                    }
                }
            } else if (fin) {
                payload = ByteBuffer.wrap(new byte[]{0});
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressed {}: input:{} -> payload:{}", new Object[]{entry, outputLength, payload.remaining()});
            }
            boolean continuation = frame.getType().isContinuation() || !first;
            DataFrame chunk = new DataFrame(frame, continuation);
            if (CompressExtension.this.rsvUse == 1) {
                chunk.setRsv1(!continuation);
            } else {
                chunk.setRsv1(true);
            }
            chunk.setPayload(payload);
            chunk.setFin(fin);
            CompressExtension.this.nextOutgoingFrame(chunk, this, entry.batchMode);
        }

        protected void onCompleteSuccess() {
        }

        protected void onCompleteFailure(Throwable x) {
            FrameEntry entry;
            while ((entry = (FrameEntry)CompressExtension.this.entries.poll()) != null) {
                CompressExtension.this.notifyCallbackFailure(entry.callback, x);
            }
        }

        public void writeSuccess() {
            if (this.finished) {
                CompressExtension.this.notifyCallbackSuccess(this.current.callback);
            }
            this.succeeded();
        }

        public void writeFailed(Throwable x) {
            CompressExtension.this.notifyCallbackFailure(this.current.callback, x);
            this.failed(x);
        }
    }

    private static class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;

        private FrameEntry(Frame frame, WriteCallback callback, BatchMode batchMode) {
            this.frame = frame;
            this.callback = callback;
            this.batchMode = batchMode;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

