/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.io;

import org.eclipse.jetty.util.FuturePromise;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.ClientUpgradeResponse;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.common.WebSocketSession;
import org.eclipse.jetty.websocket.client.common.events.EventDriver;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.client.masks.Masker;

public abstract class ConnectPromise
extends FuturePromise<Session>
implements Runnable {
    private final WebSocketClient client;
    private final EventDriver driver;
    private final ClientUpgradeRequest request;
    private final Masker masker;
    private UpgradeListener upgradeListener;
    private ClientUpgradeResponse response;

    public ConnectPromise(WebSocketClient client, EventDriver driver, ClientUpgradeRequest request) {
        this.client = client;
        this.driver = driver;
        this.request = request;
        this.masker = client.getMasker();
    }

    public void failed(Throwable cause) {
        this.driver.onError(cause);
        super.failed(cause);
    }

    public WebSocketClient getClient() {
        return this.client;
    }

    public EventDriver getDriver() {
        return this.driver;
    }

    public Masker getMasker() {
        return this.masker;
    }

    public ClientUpgradeRequest getRequest() {
        return this.request;
    }

    public ClientUpgradeResponse getResponse() {
        return this.response;
    }

    public UpgradeListener getUpgradeListener() {
        return this.upgradeListener;
    }

    public void setResponse(ClientUpgradeResponse response) {
        this.response = response;
    }

    public void setUpgradeListener(UpgradeListener upgradeListener) {
        this.upgradeListener = upgradeListener;
    }

    public void succeeded(WebSocketSession session) {
        session.setUpgradeRequest(this.request);
        session.setUpgradeResponse(this.response);
        session.open();
        super.succeeded((Object)session);
    }
}

