/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.ConnectionState;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.io.IOState;

@ManagedObject(value="A Jetty WebSocket Session")
public class WebSocketSession
extends ContainerLifeCycle
implements Session,
IncomingFrames,
IOState.ConnectionStateListener {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private final URI requestURI;
    private final EventDriver websocket;
    private final LogicalConnection connection;
    private ExtensionFactory extensionFactory;
    private long maximumMessageSize;
    private String protocolVersion;
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private WebSocketRemoteEndpoint remote;
    private IncomingFrames incomingHandler;
    private OutgoingFrames outgoingHandler;
    private WebSocketPolicy policy;
    private UpgradeRequest upgradeRequest;
    private UpgradeResponse upgradeResponse;

    public WebSocketSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        if (requestURI == null) {
            throw new RuntimeException("Request URI cannot be null");
        }
        this.requestURI = requestURI;
        this.websocket = websocket;
        this.connection = connection;
        this.outgoingHandler = connection;
        this.incomingHandler = websocket;
        this.connection.getIOState().addListener(this);
        MultiMap params = new MultiMap();
        String query = requestURI.getQuery();
        if (StringUtil.isNotBlank((String)query)) {
            UrlEncoded.decodeTo((String)query, (MultiMap)params, (Charset)StringUtil.__UTF8_CHARSET, (int)-1);
        }
        for (String name : params.keySet()) {
            List valueList = params.getValues(name);
            String[] valueArr = new String[valueList.size()];
            valueArr = valueList.toArray(valueArr);
            this.parameterMap.put(name, valueArr);
        }
    }

    public void close() throws IOException {
        this.close(1000, null);
    }

    public void close(CloseStatus closeStatus) {
        this.close(closeStatus.getCode(), closeStatus.getPhrase());
    }

    public void close(int statusCode, String reason) {
        this.connection.close(statusCode, reason);
        this.notifyClose(statusCode, reason);
    }

    public void disconnect() {
        this.connection.disconnect();
        this.notifyClose(1006, "Harsh disconnect");
    }

    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        out.append(indent).append(" +- incomingHandler : ");
        if (this.incomingHandler instanceof Dumpable) {
            ((Dumpable)this.incomingHandler).dump(out, indent + "    ");
        } else {
            out.append(this.incomingHandler.toString()).append('\n');
        }
        out.append(indent).append(" +- outgoingHandler : ");
        if (this.outgoingHandler instanceof Dumpable) {
            ((Dumpable)this.outgoingHandler).dump(out, indent + "    ");
        } else {
            out.append(this.outgoingHandler.toString()).append('\n');
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSocketSession other = (WebSocketSession)obj;
        return !(this.connection == null ? other.connection != null : !this.connection.equals(other.connection));
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    public long getIdleTimeout() {
        return this.connection.getMaxIdleTimeout();
    }

    @ManagedAttribute(readonly=true)
    public IncomingFrames getIncomingHandler() {
        return this.incomingHandler;
    }

    public InetSocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    public long getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    @ManagedAttribute(readonly=true)
    public OutgoingFrames getOutgoingHandler() {
        return this.outgoingHandler;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public RemoteEndpoint getRemote() {
        if (!this.isOpen()) {
            throw new WebSocketException("Session has not been opened yet");
        }
        return this.remote;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remote.getInetSocketAddress();
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        return result;
    }

    public void incomingError(WebSocketException e) {
        if (this.connection.getIOState().isInputAvailable()) {
            this.websocket.incomingError(e);
        }
    }

    public void incomingFrame(Frame frame) {
        if (this.connection.getIOState().isInputAvailable()) {
            this.incomingHandler.incomingFrame(frame);
        }
    }

    public boolean isOpen() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.isOpen();
    }

    public boolean isSecure() {
        if (this.upgradeRequest == null) {
            throw new IllegalStateException("No valid UpgradeRequest yet");
        }
        URI requestURI = this.upgradeRequest.getRequestURI();
        return "wss".equalsIgnoreCase(requestURI.getScheme());
    }

    public void notifyClose(int statusCode, String reason) {
        this.websocket.onClose(new CloseInfo(statusCode, reason));
    }

    @Override
    public void onConnectionStateChange(ConnectionState state) {
        IOState ioState;
        if (state == ConnectionState.CLOSED && (ioState = this.connection.getIOState()).wasAbnormalClose()) {
            CloseInfo close = ioState.getCloseInfo();
            LOG.debug("Detected abnormal close: {}", new Object[]{close});
            this.notifyClose(close.getStatusCode(), close.getReason());
        }
    }

    public void open() {
        if (this.remote != null) {
            return;
        }
        this.connection.getIOState().onConnected();
        this.remote = new WebSocketRemoteEndpoint(this.connection, this.outgoingHandler);
        this.websocket.openSession(this);
        this.connection.getIOState().onOpened();
        if (LOG.isDebugEnabled()) {
            LOG.debug("open -> {}", new Object[]{this.dump()});
        }
    }

    public void setExtensionFactory(ExtensionFactory extensionFactory) {
        this.extensionFactory = extensionFactory;
    }

    public void setIdleTimeout(long ms) {
        this.connection.setMaxIdleTimeout(ms);
    }

    public void setMaximumMessageSize(long length) {
        this.maximumMessageSize = length;
    }

    public void setOutgoingHandler(OutgoingFrames outgoing) {
        this.outgoingHandler = outgoing;
    }

    public void setPolicy(WebSocketPolicy policy) {
        this.policy = policy;
    }

    public void setUpgradeRequest(UpgradeRequest request) {
        this.upgradeRequest = request;
    }

    public void setUpgradeResponse(UpgradeResponse response) {
        this.upgradeResponse = response;
    }

    public SuspendToken suspend() {
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketSession[");
        builder.append("websocket=").append(this.websocket);
        builder.append(",behavior=").append(this.policy.getBehavior());
        builder.append(",connection=").append(this.connection);
        builder.append(",remote=").append(this.remote);
        builder.append(",incoming=").append(this.incomingHandler);
        builder.append(",outgoing=").append(this.outgoingHandler);
        builder.append("]");
        return builder.toString();
    }
}

