/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.api.io;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.api.WebSocketConnection;
import org.eclipse.jetty.websocket.core.io.WebSocketSession;

public class WebSocketBlockingConnection {
    private static final Logger LOG = Log.getLogger(WebSocketBlockingConnection.class);
    private static final String CONTEXT_BINARY = "BLOCKING_BINARY";
    private static final String CONTEXT_TEXT = "BLOCKING_TEXT";
    private final WebSocketSession conn;

    public WebSocketBlockingConnection(WebSocketConnection conn) {
        if (!(conn instanceof WebSocketSession)) {
            throw new IllegalArgumentException("WebSocketConnection must implement internal WebSocketSession interface");
        }
        this.conn = (WebSocketSession)conn;
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        try {
            Blocker blocker = new Blocker();
            this.conn.write(CONTEXT_BINARY, blocker, data, offset, length);
            blocker.get();
        }
        catch (InterruptedException e) {
            throw new IOException("Blocking write failed", e);
        }
        catch (ExecutionException e) {
            FutureCallback.rethrow((ExecutionException)e);
        }
    }

    public void write(String message) throws IOException {
        try {
            Blocker blocker = new Blocker();
            this.conn.write(CONTEXT_TEXT, blocker, message);
            blocker.get();
        }
        catch (InterruptedException e) {
            throw new IOException("Blocking write failed", e);
        }
        catch (ExecutionException e) {
            FutureCallback.rethrow((ExecutionException)e);
        }
    }

    private static class Blocker
    extends FutureCallback<String> {
        private Blocker() {
        }

        public void completed(String context) {
            LOG.debug("completed({})", new Object[]{context});
            super.completed((Object)context);
        }

        public void failed(String context, Throwable cause) {
            LOG.debug("failed({},{})", new Object[]{context, cause});
            super.failed((Object)context, cause);
        }

        public String toString() {
            return String.format("%s[%s]", Blocker.class.getSimpleName(), super.toString());
        }
    }
}

