/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.core.api.Extension;
import org.eclipse.jetty.websocket.core.api.ExtensionRegistry;
import org.eclipse.jetty.websocket.core.api.WebSocketException;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.core.extensions.compress.PerMessageCompressionExtension;
import org.eclipse.jetty.websocket.core.extensions.compress.WebkitDeflateFrameExtension;
import org.eclipse.jetty.websocket.core.extensions.fragment.FragmentExtension;
import org.eclipse.jetty.websocket.core.extensions.identity.IdentityExtension;
import org.eclipse.jetty.websocket.core.protocol.ExtensionConfig;

public class WebSocketExtensionRegistry
implements ExtensionRegistry {
    private Map<String, Class<? extends Extension>> registry;
    private WebSocketPolicy policy;
    private ByteBufferPool bufferPool;

    public WebSocketExtensionRegistry(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.policy = policy;
        this.bufferPool = bufferPool;
        this.registry = new HashMap<String, Class<? extends Extension>>();
        this.registry.put("identity", IdentityExtension.class);
        this.registry.put("fragment", FragmentExtension.class);
        this.registry.put("x-webkit-deflate-frame", WebkitDeflateFrameExtension.class);
        this.registry.put("permessage-compress", PerMessageCompressionExtension.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable(String name) {
        Map<String, Class<? extends Extension>> map = this.registry;
        synchronized (map) {
            return this.registry.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Class<? extends Extension>> iterator() {
        ArrayList<Class<? extends Extension>> coll = new ArrayList<Class<? extends Extension>>();
        Map<String, Class<? extends Extension>> map = this.registry;
        synchronized (map) {
            coll.addAll(this.registry.values());
            return coll.iterator();
        }
    }

    public Extension newInstance(ExtensionConfig config) {
        if (config == null) {
            return null;
        }
        String name = config.getName();
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        Class<? extends Extension> extClass = this.registry.get(name);
        if (extClass == null) {
            return null;
        }
        try {
            Extension ext = extClass.newInstance();
            ext.setConfig(config);
            ext.setPolicy(this.policy);
            ext.setBufferPool(this.bufferPool);
            return ext;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WebSocketException("Cannot instantiate extension: " + extClass, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(String name, Class<? extends Extension> extension) {
        Map<String, Class<? extends Extension>> map = this.registry;
        synchronized (map) {
            this.registry.put(name, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(String name) {
        Map<String, Class<? extends Extension>> map = this.registry;
        synchronized (map) {
            this.registry.remove(name);
        }
    }
}

