/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.extensions.mux;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.api.BaseConnection;
import org.eclipse.jetty.websocket.core.api.Extension;
import org.eclipse.jetty.websocket.core.api.WebSocketConnection;
import org.eclipse.jetty.websocket.core.api.WebSocketException;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.core.extensions.mux.Muxer;
import org.eclipse.jetty.websocket.core.io.IncomingFrames;
import org.eclipse.jetty.websocket.core.io.OutgoingFrames;
import org.eclipse.jetty.websocket.core.io.WebSocketSession;
import org.eclipse.jetty.websocket.core.protocol.CloseInfo;
import org.eclipse.jetty.websocket.core.protocol.ConnectionState;
import org.eclipse.jetty.websocket.core.protocol.WebSocketFrame;

public class MuxChannel
implements WebSocketConnection,
IncomingFrames,
OutgoingFrames,
BaseConnection.SuspendToken {
    private static final Logger LOG = Log.getLogger(MuxChannel.class);
    private final long channelId;
    private final Muxer muxer;
    private final AtomicBoolean inputClosed;
    private final AtomicBoolean outputClosed;
    private final AtomicBoolean suspendToken;
    private ConnectionState connectionState;
    private WebSocketPolicy policy;
    private WebSocketSession session;
    private IncomingFrames incoming;
    private String subProtocol;

    public MuxChannel(long channelId, Muxer muxer) {
        this.channelId = channelId;
        this.muxer = muxer;
        this.policy = muxer.getPolicy().clonePolicy();
        this.suspendToken = new AtomicBoolean(false);
        this.connectionState = ConnectionState.CONNECTING;
        this.inputClosed = new AtomicBoolean(false);
        this.outputClosed = new AtomicBoolean(false);
    }

    @Override
    public void close() {
        this.close(1000, null);
    }

    @Override
    public void close(int statusCode, String reason) {
        CloseInfo close = new CloseInfo(statusCode, reason);
        try {
            this.output((Object)"<close>", (Callback)new FutureCallback(), close.asFrame());
        }
        catch (IOException e) {
            LOG.warn("Unable to issue Close", (Throwable)e);
            this.disconnect();
        }
    }

    @Override
    public void disconnect() {
        this.connectionState = ConnectionState.CLOSED;
    }

    public long getChannelId() {
        return this.channelId;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.muxer.getRemoteAddress();
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    @Override
    public ConnectionState getState() {
        return this.connectionState;
    }

    @Override
    public String getSubProtocol() {
        return this.subProtocol;
    }

    @Override
    public void incoming(WebSocketException e) {
        this.incoming.incoming(e);
    }

    @Override
    public void incoming(WebSocketFrame frame) {
        this.incoming.incoming(frame);
    }

    public boolean isActive() {
        return this.getState() != ConnectionState.CLOSED;
    }

    @Override
    public boolean isInputClosed() {
        return this.inputClosed.get();
    }

    @Override
    public boolean isOpen() {
        return this.isActive() && this.muxer.isOpen();
    }

    @Override
    public boolean isOutputClosed() {
        return this.outputClosed.get();
    }

    @Override
    public boolean isReading() {
        return true;
    }

    public void onClose() {
        this.connectionState = ConnectionState.CLOSED;
    }

    @Override
    public void onCloseHandshake(boolean incoming, CloseInfo close) {
        boolean in = this.inputClosed.get();
        boolean out = this.outputClosed.get();
        if (incoming) {
            in = true;
            this.inputClosed.set(true);
        } else {
            out = true;
            this.outputClosed.set(true);
        }
        LOG.debug("onCloseHandshake({},{}), input={}, output={}", new Object[]{incoming, close, in, out});
        if (in && out) {
            LOG.debug("Close Handshake satisfied, disconnecting", new Object[0]);
            this.disconnect();
        }
        if (close.isHarsh()) {
            LOG.debug("Close status code was harsh, disconnecting", new Object[0]);
            this.disconnect();
        }
    }

    public void onOpen() {
        this.connectionState = ConnectionState.OPEN;
    }

    @Override
    public <C> void output(C context, Callback<C> callback, WebSocketFrame frame) throws IOException {
        this.muxer.output(context, callback, this.channelId, frame);
    }

    @Override
    public <C> void ping(C context, Callback<C> callback, byte[] payload) throws IOException {
        this.output(context, callback, WebSocketFrame.ping().setPayload(payload));
    }

    @Override
    public void resume() {
        if (this.suspendToken.getAndSet(false)) {
            // empty if block
        }
    }

    public void setSession(WebSocketSession session) {
        this.session = session;
        this.incoming = session;
        session.setOutgoing(this);
    }

    public void setSubProtocol(String subProtocol) {
        this.subProtocol = subProtocol;
    }

    @Override
    public BaseConnection.SuspendToken suspend() {
        this.suspendToken.set(true);
        return this;
    }

    public void wireUpExtensions(List<Extension> extensions) {
        this.incoming = this.session;
        IncomingFrames outgoing = this;
        if (extensions != null) {
            for (Extension ext : extensions) {
                ext.setNextOutgoingFrames((OutgoingFrames)((Object)outgoing));
                outgoing = ext;
            }
            Collections.reverse(extensions);
            for (Extension ext : extensions) {
                ext.setNextIncomingFrames(this.incoming);
                this.incoming = ext;
            }
        }
        this.session.setOutgoing((OutgoingFrames)((Object)outgoing));
    }

    @Override
    public <C> void write(C context, Callback<C> callback, byte[] buf, int offset, int len) throws IOException {
        this.output(context, callback, WebSocketFrame.binary().setPayload(buf, offset, len));
    }

    @Override
    public <C> void write(C context, Callback<C> callback, ByteBuffer buffer) throws IOException {
        this.output(context, callback, WebSocketFrame.binary().setPayload(buffer));
    }

    @Override
    public <C> void write(C context, Callback<C> callback, String message) throws IOException {
        this.output(context, callback, WebSocketFrame.text(message));
    }
}

