/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.extensions.mux;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.websocket.core.extensions.mux.MuxControlBlock;
import org.eclipse.jetty.websocket.core.extensions.mux.MuxException;
import org.eclipse.jetty.websocket.core.extensions.mux.op.MuxAddChannelRequest;
import org.eclipse.jetty.websocket.core.extensions.mux.op.MuxAddChannelResponse;
import org.eclipse.jetty.websocket.core.extensions.mux.op.MuxDropChannel;
import org.eclipse.jetty.websocket.core.extensions.mux.op.MuxFlowControl;
import org.eclipse.jetty.websocket.core.extensions.mux.op.MuxNewChannelSlot;
import org.eclipse.jetty.websocket.core.io.OutgoingFrames;
import org.eclipse.jetty.websocket.core.protocol.WebSocketFrame;

public class MuxGenerator {
    private static final int CONTROL_BUFFER_SIZE = 2048;
    private static final int DATA_FRAME_OVERHEAD = 5;
    private ByteBufferPool bufferPool;
    private OutgoingFrames outgoing;

    public MuxGenerator() {
        this((ByteBufferPool)new ArrayByteBufferPool());
    }

    public MuxGenerator(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public void generate(long channelId, WebSocketFrame frame) throws IOException {
        this.output(null, (Callback)new FutureCallback(), channelId, frame);
    }

    public void generate(MuxControlBlock ... blocks) throws IOException {
        if (blocks == null || blocks.length <= 0) {
            return;
        }
        ByteBuffer payload = this.bufferPool.acquire(2048, false);
        BufferUtil.flipToFill((ByteBuffer)payload);
        this.writeChannelId(payload, 0L);
        block7: for (MuxControlBlock block : blocks) {
            switch (block.getOpCode()) {
                case 0: {
                    MuxControlBlock op = (MuxAddChannelRequest)block;
                    byte b = (byte)((((MuxAddChannelRequest)op).getOpCode() & 7) << 5);
                    b = (byte)(b | (byte)((((MuxAddChannelRequest)op).getRsv() & 7) << 2));
                    b = (byte)(b | ((MuxAddChannelRequest)op).getEnc() & 3);
                    payload.put(b);
                    this.writeChannelId(payload, ((MuxAddChannelRequest)op).getChannelId());
                    this.write139Buffer(payload, ((MuxAddChannelRequest)op).getHandshake());
                    continue block7;
                }
                case 1: {
                    MuxControlBlock op = (MuxAddChannelResponse)block;
                    byte b = (byte)((((MuxAddChannelResponse)op).getOpCode() & 7) << 5);
                    b = (byte)(b | (((MuxAddChannelResponse)op).isFailed() ? 16 : 0));
                    b = (byte)(b | (byte)((((MuxAddChannelResponse)op).getRsv() & 3) << 2));
                    b = (byte)(b | ((MuxAddChannelResponse)op).getEnc() & 3);
                    payload.put(b);
                    this.writeChannelId(payload, ((MuxAddChannelResponse)op).getChannelId());
                    if (((MuxAddChannelResponse)op).getHandshake() != null) {
                        this.write139Buffer(payload, ((MuxAddChannelResponse)op).getHandshake());
                        continue block7;
                    }
                    this.write139Size(payload, 0L);
                    continue block7;
                }
                case 3: {
                    MuxControlBlock op = (MuxDropChannel)block;
                    byte b = (byte)((((MuxDropChannel)op).getOpCode() & 7) << 5);
                    b = (byte)(b | (byte)(((MuxDropChannel)op).getRsv() & 0x1F));
                    payload.put(b);
                    this.writeChannelId(payload, ((MuxDropChannel)op).getChannelId());
                    this.write139Buffer(payload, ((MuxDropChannel)op).asReasonBuffer());
                    continue block7;
                }
                case 2: {
                    MuxControlBlock op = (MuxFlowControl)block;
                    byte b = (byte)((((MuxFlowControl)op).getOpCode() & 7) << 5);
                    b = (byte)(b | (byte)(((MuxFlowControl)op).getRsv() & 0x1F));
                    payload.put(b);
                    this.writeChannelId(payload, ((MuxFlowControl)op).getChannelId());
                    this.write139Size(payload, ((MuxFlowControl)op).getSendQuotaSize());
                    continue block7;
                }
                case 4: {
                    MuxControlBlock op = (MuxNewChannelSlot)block;
                    byte b = (byte)((((MuxNewChannelSlot)op).getOpCode() & 7) << 5);
                    b = (byte)(b | (byte)(((MuxNewChannelSlot)op).getRsv() & 0xF) << 1);
                    b = (byte)(b | (byte)(((MuxNewChannelSlot)op).isFallback() ? 1 : 0));
                    payload.put(b);
                    this.write139Size(payload, ((MuxNewChannelSlot)op).getNumberOfSlots());
                    this.write139Size(payload, ((MuxNewChannelSlot)op).getInitialSendQuota());
                    continue block7;
                }
            }
        }
        BufferUtil.flipToFlush((ByteBuffer)payload, (int)0);
        WebSocketFrame frame = WebSocketFrame.binary();
        frame.setPayload(payload);
        this.outgoing.output(null, new FutureCallback(), frame);
    }

    public OutgoingFrames getOutgoing() {
        return this.outgoing;
    }

    public <C> void output(C context, Callback<C> callback, long channelId, WebSocketFrame frame) throws IOException {
        ByteBuffer muxPayload = this.bufferPool.acquire(frame.getPayloadLength() + 5, false);
        BufferUtil.flipToFill((ByteBuffer)muxPayload);
        this.writeChannelId(muxPayload, channelId);
        byte b = (byte)(frame.isFin() ? 128 : 0);
        b = (byte)(b | (byte)(frame.isRsv1() ? 64 : 0));
        b = (byte)(b | (byte)(frame.isRsv2() ? 32 : 0));
        b = (byte)(b | (byte)(frame.isRsv3() ? 16 : 0));
        b = (byte)(b | (byte)(frame.getOpCode() & 0xF));
        muxPayload.put(b);
        BufferUtil.put((ByteBuffer)frame.getPayload(), (ByteBuffer)muxPayload);
        WebSocketFrame muxFrame = WebSocketFrame.binary();
        BufferUtil.flipToFlush((ByteBuffer)muxPayload, (int)0);
        muxFrame.setPayload(muxPayload);
        this.bufferPool.release(frame.getPayload());
        this.outgoing.output(context, callback, muxFrame);
    }

    public void setOutgoing(OutgoingFrames outgoing) {
        this.outgoing = outgoing;
    }

    public void write139Buffer(ByteBuffer payload, ByteBuffer buffer) {
        this.write139Size(payload, buffer.remaining());
        this.writeBuffer(payload, buffer);
    }

    public void write139Size(ByteBuffer payload, long size) {
        if (size > 65535L) {
            payload.put((byte)127);
            payload.putLong(size);
            return;
        }
        if (size >= 126L) {
            payload.put((byte)126);
            payload.put((byte)(size >> 8));
            payload.put((byte)(size & 0xFFL));
            return;
        }
        payload.put((byte)(size & 0x7FL));
    }

    public void writeBuffer(ByteBuffer payload, ByteBuffer buffer) {
        BufferUtil.put((ByteBuffer)buffer, (ByteBuffer)payload);
    }

    public void writeChannelId(ByteBuffer payload, long channelId) {
        if (channelId > 0x1FFFFFFFL) {
            throw new MuxException("Illegal Channel ID: too big");
        }
        if (channelId > 0x1FFFFFL) {
            payload.put((byte)(0xE0L | channelId >> 24 & 0x1FL));
            payload.put((byte)(channelId >> 16 & 0xFFL));
            payload.put((byte)(channelId >> 8 & 0xFFL));
            payload.put((byte)(channelId & 0xFFL));
            return;
        }
        if (channelId > 16383L) {
            payload.put((byte)(0xC0L | channelId >> 16 & 0x1FL));
            payload.put((byte)(channelId >> 8 & 0xFFL));
            payload.put((byte)(channelId & 0xFFL));
            return;
        }
        if (channelId > 127L) {
            payload.put((byte)(0x80L | channelId >> 8 & 0x3FL));
            payload.put((byte)(channelId & 0xFFL));
            return;
        }
        payload.put((byte)(channelId & 0x7FL));
    }
}

