/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.extensions.mux.op;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.websocket.core.extensions.mux.MuxControlBlock;

public class MuxDropChannel
implements MuxControlBlock {
    private final long channelId;
    private final Reason code;
    private String phrase;
    private int rsv;

    public static MuxDropChannel parse(long channelId, ByteBuffer payload) {
        return null;
    }

    public MuxDropChannel(long channelId) {
        this(channelId, Reason.NORMAL_CLOSURE, null);
    }

    public MuxDropChannel(long channelId, int code, String phrase) {
        this(channelId, Reason.valueOf(code), phrase);
    }

    public MuxDropChannel(long channelId, Reason code, String phrase) {
        this.channelId = channelId;
        this.code = code;
        this.phrase = phrase;
    }

    public ByteBuffer asReasonBuffer() {
        return null;
    }

    public long getChannelId() {
        return this.channelId;
    }

    public Reason getCode() {
        return this.code;
    }

    @Override
    public int getOpCode() {
        return 3;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public int getRsv() {
        return this.rsv;
    }

    public void setRsv(int rsv) {
        this.rsv = rsv;
    }

    public static enum Reason {
        NORMAL_CLOSURE(1000),
        PHYSICAL_CONNECTION_FAILED(2000),
        INVALID_ENCAPSULATING_MESSAGE(2001),
        CHANNEL_ID_TRUNCATED(2002),
        ENCAPSULATED_FRAME_TRUNCATED(2003),
        UNKNOWN_MUX_CONTROL_OPC(2004),
        UNKNOWN_MUX_CONTROL_BLOCK(2005),
        CHANNEL_ALREADY_EXISTS(2006),
        NEW_CHANNEL_SLOT_VIOLATION(2007),
        NEW_CHANNEL_SLOT_OVERFLOW(2008),
        BAD_REQUEST(2009),
        UNKNOWN_REQUEST_ENCODING(2010),
        BAD_RESPONSE(2011),
        UNKNOWN_RESPONSE_ENCODING(2012),
        LOGICAL_CHANNEL_FAILED(3000),
        SEND_QUOTA_VIOLATION(3005),
        SEND_QUOTA_OVERFLOW(3006),
        IDLE_TIMEOUT(3007),
        DROP_CHANNEL_ACK(3008),
        USE_ANOTHER_PHYSICAL_CONNECTION(4001),
        BUSY(4002);

        private static final Map<Integer, Reason> codeMap;
        private final int code;

        public static Reason valueOf(int code) {
            return codeMap.get(code);
        }

        private Reason(int code) {
            this.code = code;
        }

        public int getValue() {
            return this.code;
        }

        static {
            codeMap = new HashMap<Integer, Reason>();
            for (Reason r : Reason.values()) {
                codeMap.put(r.getValue(), r);
            }
        }
    }
}

