/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.io;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.io.AbstractWebSocketConnection;
import org.eclipse.jetty.websocket.core.io.FrameBytes;
import org.eclipse.jetty.websocket.core.protocol.WebSocketFrame;

public class DataFrameBytes<C>
extends FrameBytes<C> {
    private static final Logger LOG = Log.getLogger(DataFrameBytes.class);
    private ByteBuffer buffer;

    public DataFrameBytes(AbstractWebSocketConnection connection, Callback<C> callback, C context, WebSocketFrame frame) {
        super(connection, callback, context, frame);
    }

    @Override
    public void completed(C context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("completed({}) - frame.remaining() = {}", new Object[]{context, this.frame.remaining()});
        }
        this.connection.getBufferPool().release(this.buffer);
        if (this.frame.remaining() > 0) {
            LOG.debug("More to send", new Object[0]);
            this.connection.getQueue().prepend(this);
            this.connection.complete(this);
        } else {
            LOG.debug("Send complete", new Object[0]);
            super.completed(context);
        }
        this.connection.flush();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        try {
            int windowSize = this.connection.getInputBufferSize();
            this.buffer = this.connection.getGenerator().generate(windowSize, this.frame);
            return this.buffer;
        }
        catch (Throwable x) {
            this.failed(this.context, x);
            return null;
        }
    }
}

