/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.io.event;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.api.CloseException;
import org.eclipse.jetty.websocket.core.api.WebSocketException;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.core.io.IncomingFrames;
import org.eclipse.jetty.websocket.core.io.WebSocketSession;
import org.eclipse.jetty.websocket.core.protocol.CloseInfo;
import org.eclipse.jetty.websocket.core.protocol.WebSocketFrame;

public abstract class EventDriver
implements IncomingFrames {
    protected final Logger LOG;
    protected final WebSocketPolicy policy;
    protected final Object websocket;
    protected WebSocketSession session;

    public EventDriver(WebSocketPolicy policy, Object websocket) {
        this.policy = policy;
        this.websocket = websocket;
        this.LOG = Log.getLogger(websocket.getClass());
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    @Override
    public final void incoming(WebSocketException e) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("incoming(WebSocketException)", (Throwable)e);
        }
        if (e instanceof CloseException) {
            CloseException close = (CloseException)e;
            this.terminateConnection(close.getStatusCode(), close.getMessage());
        }
        this.onException(e);
    }

    @Override
    public final void incoming(WebSocketFrame frame) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("{}.onFrame({})", new Object[]{this.websocket.getClass().getSimpleName(), frame});
        }
        this.onFrame(frame);
        try {
            switch (frame.getOpCode()) {
                case 8: {
                    boolean validate = true;
                    CloseInfo close = new CloseInfo(frame, validate);
                    this.onClose(close);
                    this.session.close(close.getStatusCode(), close.getReason());
                    this.session.onCloseHandshake(true, close);
                    return;
                }
                case 9: {
                    WebSocketFrame pong = new WebSocketFrame(10);
                    if (frame.getPayloadLength() > 0) {
                        ByteBuffer pongBuf = ByteBuffer.allocate(frame.getPayloadLength());
                        BufferUtil.clearToFill((ByteBuffer)pongBuf);
                        BufferUtil.put((ByteBuffer)frame.getPayload(), (ByteBuffer)pongBuf);
                        BufferUtil.flipToFlush((ByteBuffer)pongBuf, (int)0);
                        pong.setPayload(pongBuf);
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug("Pong with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)pongBuf)});
                        }
                    }
                    this.session.output("pong", new FutureCallback(), pong);
                    break;
                }
                case 2: {
                    this.onBinaryFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 1: {
                    this.onTextFrame(frame.getPayload(), frame.isFin());
                    return;
                }
            }
        }
        catch (Utf8Appendable.NotUtf8Exception e) {
            this.terminateConnection(1007, e.getMessage());
        }
        catch (CloseException e) {
            this.terminateConnection(e.getStatusCode(), e.getMessage());
        }
        catch (Throwable t) {
            this.unhandled(t);
        }
    }

    public abstract void onBinaryFrame(ByteBuffer var1, boolean var2) throws IOException;

    public abstract void onBinaryMessage(byte[] var1);

    public abstract void onClose(CloseInfo var1);

    public abstract void onConnect();

    public abstract void onException(WebSocketException var1);

    public abstract void onFrame(WebSocketFrame var1);

    public abstract void onTextFrame(ByteBuffer var1, boolean var2) throws IOException;

    public abstract void onTextMessage(String var1);

    public void setSession(WebSocketSession session) {
        this.session = session;
    }

    protected void terminateConnection(int statusCode, String rawreason) {
        String reason = rawreason;
        reason = StringUtil.truncate((String)reason, (int)123);
        this.LOG.debug("terminateConnection({},{})", new Object[]{statusCode, rawreason});
        this.session.close(statusCode, reason);
    }

    private void unhandled(Throwable t) {
        this.LOG.warn("Unhandled Error (closing connection)", t);
        switch (this.policy.getBehavior()) {
            case SERVER: {
                this.terminateConnection(1011, t.getClass().getSimpleName());
                break;
            }
            case CLIENT: {
                this.terminateConnection(1008, t.getClass().getSimpleName());
            }
        }
    }
}

