/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.io.event;

import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.core.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.core.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.core.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.core.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.core.annotations.WebSocket;
import org.eclipse.jetty.websocket.core.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.core.api.WebSocketConnection;
import org.eclipse.jetty.websocket.core.api.WebSocketListener;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.core.io.event.AnnotatedEventDriver;
import org.eclipse.jetty.websocket.core.io.event.EventDriver;
import org.eclipse.jetty.websocket.core.io.event.EventMethod;
import org.eclipse.jetty.websocket.core.io.event.EventMethods;
import org.eclipse.jetty.websocket.core.io.event.InvalidSignatureException;
import org.eclipse.jetty.websocket.core.io.event.ListenerEventDriver;
import org.eclipse.jetty.websocket.core.io.event.ParamList;
import org.eclipse.jetty.websocket.core.protocol.Frame;

public class EventDriverFactory {
    private static final ParamList validBinaryParams;
    private static final ParamList validConnectParams;
    private static final ParamList validCloseParams;
    private static final ParamList validFrameParams;
    private static final ParamList validTextParams;
    private ConcurrentHashMap<Class<?>, EventMethods> cache;
    private final WebSocketPolicy policy;

    public EventDriverFactory(WebSocketPolicy policy) {
        this.policy = policy;
        this.cache = new ConcurrentHashMap();
    }

    private void assertIsPublicNonStatic(Method method) {
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("Invalid declaration of ");
            err.append(method);
            err.append(StringUtil.__LINE_SEPARATOR);
            err.append("Method modifier must be public");
            throw new InvalidWebSocketException(err.toString());
        }
        if (Modifier.isStatic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("Invalid declaration of ");
            err.append(method);
            err.append(StringUtil.__LINE_SEPARATOR);
            err.append("Method modifier may not be static");
            throw new InvalidWebSocketException(err.toString());
        }
    }

    private void assertIsReturn(Method method, Class<?> type) {
        if (!type.equals(method.getReturnType())) {
            StringBuilder err = new StringBuilder();
            err.append("Invalid declaration of ");
            err.append(method);
            err.append(StringUtil.__LINE_SEPARATOR);
            err.append("Return type must be ").append(type);
            throw new InvalidWebSocketException(err.toString());
        }
    }

    private void assertUnset(EventMethod event, Class<? extends Annotation> annoClass, Method method) {
        if (event != null) {
            StringBuilder err = new StringBuilder();
            err.append("Duplicate @").append(annoClass.getSimpleName()).append(" declaration on ");
            err.append(method);
            err.append(StringUtil.__LINE_SEPARATOR);
            err.append("@").append(annoClass.getSimpleName()).append(" previously declared at ");
            err.append(event.getMethod());
            throw new InvalidWebSocketException(err.toString());
        }
    }

    private void assertValidSignature(Method method, Class<? extends Annotation> annoClass, ParamList validParams) {
        this.assertIsPublicNonStatic(method);
        this.assertIsReturn(method, Void.TYPE);
        boolean valid = false;
        Class<?>[] actual = method.getParameterTypes();
        for (Class[] params : validParams) {
            if (!this.isSameParameters(actual, params)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw InvalidSignatureException.build(method, annoClass, validParams);
        }
    }

    private EventMethods discoverMethods(Class<?> pojo) throws InvalidWebSocketException {
        WebSocket anno = pojo.getAnnotation(WebSocket.class);
        if (anno == null) {
            return null;
        }
        return this.scanAnnotatedMethods(pojo);
    }

    public EventMethods getMethods(Class<?> pojo) throws InvalidWebSocketException {
        if (pojo == null) {
            throw new InvalidWebSocketException("Cannot get methods for null class");
        }
        if (this.cache.containsKey(pojo)) {
            return this.cache.get(pojo);
        }
        EventMethods methods = this.discoverMethods(pojo);
        if (methods == null) {
            return null;
        }
        this.cache.put(pojo, methods);
        return methods;
    }

    private boolean isSameParameters(Class<?>[] actual, Class<?>[] params) {
        if (actual.length != params.length) {
            return false;
        }
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            if (actual[i].equals(params[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isSignatureMatch(Method method, ParamList validParams) {
        this.assertIsPublicNonStatic(method);
        this.assertIsReturn(method, Void.TYPE);
        Class<?>[] actual = method.getParameterTypes();
        for (Class[] params : validParams) {
            if (!this.isSameParameters(actual, params)) continue;
            return true;
        }
        return false;
    }

    private EventMethods scanAnnotatedMethods(Class<?> pojo) {
        Class<?> clazz = pojo;
        EventMethods events = new EventMethods(pojo);
        clazz = pojo;
        while (clazz.getAnnotation(WebSocket.class) != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getAnnotation(OnWebSocketConnect.class) != null) {
                    this.assertValidSignature(method, OnWebSocketConnect.class, validConnectParams);
                    this.assertUnset(events.onConnect, OnWebSocketConnect.class, method);
                    events.onConnect = new EventMethod(pojo, method);
                    continue;
                }
                if (method.getAnnotation(OnWebSocketMessage.class) != null) {
                    if (this.isSignatureMatch(method, validTextParams)) {
                        this.assertUnset(events.onText, OnWebSocketMessage.class, method);
                        events.onText = new EventMethod(pojo, method);
                        continue;
                    }
                    if (this.isSignatureMatch(method, validBinaryParams)) {
                        this.assertUnset(events.onBinary, OnWebSocketMessage.class, method);
                        events.onBinary = new EventMethod(pojo, method);
                        continue;
                    }
                    throw InvalidSignatureException.build(method, OnWebSocketMessage.class, validTextParams, validBinaryParams);
                }
                if (method.getAnnotation(OnWebSocketClose.class) != null) {
                    this.assertValidSignature(method, OnWebSocketClose.class, validCloseParams);
                    this.assertUnset(events.onClose, OnWebSocketClose.class, method);
                    events.onClose = new EventMethod(pojo, method);
                    continue;
                }
                if (method.getAnnotation(OnWebSocketFrame.class) == null) continue;
                this.assertValidSignature(method, OnWebSocketFrame.class, validFrameParams);
                this.assertUnset(events.onFrame, OnWebSocketFrame.class, method);
                events.onFrame = new EventMethod(pojo, method);
            }
            clazz = clazz.getSuperclass();
        }
        return events;
    }

    public String toString() {
        return String.format("EventMethodsCache [cache.count=%d]", this.cache.size());
    }

    public EventDriver wrap(Object websocket) {
        if (websocket == null) {
            throw new InvalidWebSocketException("null websocket object");
        }
        if (websocket instanceof WebSocketListener) {
            WebSocketPolicy pojoPolicy = this.policy.clonePolicy();
            WebSocketListener listener = (WebSocketListener)websocket;
            return new ListenerEventDriver(pojoPolicy, listener);
        }
        EventMethods methods = this.getMethods(websocket.getClass());
        if (methods != null) {
            WebSocketPolicy pojoPolicy = this.policy.clonePolicy();
            return new AnnotatedEventDriver(pojoPolicy, websocket, methods);
        }
        throw new InvalidWebSocketException(websocket.getClass().getName() + " does not implement " + WebSocketListener.class.getName() + " or declare @WebSocket");
    }

    static {
        validConnectParams = new ParamList();
        validConnectParams.addParams(WebSocketConnection.class);
        validCloseParams = new ParamList();
        validCloseParams.addParams(Integer.TYPE, String.class);
        validCloseParams.addParams(WebSocketConnection.class, Integer.TYPE, String.class);
        validTextParams = new ParamList();
        validTextParams.addParams(String.class);
        validTextParams.addParams(WebSocketConnection.class, String.class);
        validTextParams.addParams(Reader.class);
        validTextParams.addParams(WebSocketConnection.class, Reader.class);
        validBinaryParams = new ParamList();
        validBinaryParams.addParams(byte[].class, Integer.TYPE, Integer.TYPE);
        validBinaryParams.addParams(WebSocketConnection.class, byte[].class, Integer.TYPE, Integer.TYPE);
        validBinaryParams.addParams(InputStream.class);
        validBinaryParams.addParams(WebSocketConnection.class, InputStream.class);
        validFrameParams = new ParamList();
        validFrameParams.addParams(Frame.class);
        validFrameParams.addParams(WebSocketConnection.class, Frame.class);
    }
}

