/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.protocol;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.util.QuotedStringTokenizer;

public class ExtensionConfig {
    private final String name;
    private Map<String, String> parameters;

    public static ExtensionConfig parse(String parameterizedName) {
        QuotedStringTokenizer tok = new QuotedStringTokenizer(parameterizedName, ";");
        ExtensionConfig ext = new ExtensionConfig(tok.nextToken().trim());
        while (tok.hasMoreTokens()) {
            QuotedStringTokenizer nv = new QuotedStringTokenizer(tok.nextToken().trim(), "=");
            String key = nv.nextToken().trim();
            String value = nv.hasMoreTokens() ? nv.nextToken().trim() : null;
            ext.setParameter(key, value);
        }
        return ext;
    }

    public ExtensionConfig(String name) {
        this.name = name;
        this.parameters = new HashMap<String, String>();
    }

    public String getName() {
        return this.name;
    }

    public int getParameter(String key, int defValue) {
        String val = this.parameters.get(key);
        if (val == null) {
            return defValue;
        }
        return Integer.valueOf(val);
    }

    public String getParameter(String key, String defValue) {
        String val = this.parameters.get(key);
        if (val == null) {
            return defValue;
        }
        return val;
    }

    public String getParameterizedName() {
        StringBuilder str = new StringBuilder();
        str.append(this.name);
        for (String param : this.parameters.keySet()) {
            str.append(';').append(param).append('=').append(QuotedStringTokenizer.quoteIfNeeded((String)this.parameters.get(param), (String)";="));
        }
        return str.toString();
    }

    public Set<String> getParameterKeys() {
        return this.parameters.keySet();
    }

    public void init(ExtensionConfig other) {
        this.parameters.clear();
        this.parameters.putAll(other.parameters);
    }

    public void setParameter(String key, int value) {
        this.parameters.put(key, Integer.toString(value));
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String toString() {
        return this.getParameterizedName();
    }
}

