/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.awtui.AwtAuthenticator;
import org.eclipse.jgit.awtui.AwtCredentialsProvider;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.pgm.CommandCatalog;
import org.eclipse.jgit.pgm.CommandRef;
import org.eclipse.jgit.pgm.Die;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.Version;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.eclipse.jgit.pgm.opt.SubcommandHandler;
import org.eclipse.jgit.util.CachedAuthenticator;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;

public class Main {
    @Option(name="--help", usage="usage_displayThisHelpText", aliases={"-h"})
    private boolean help;
    @Option(name="--version", usage="usage_displayVersion")
    private boolean version;
    @Option(name="--show-stack-trace", usage="usage_displayThejavaStackTraceOnExceptions")
    private boolean showStackTrace;
    @Option(name="--git-dir", metaVar="metaVar_gitDir", usage="usage_setTheGitRepositoryToOperateOn")
    private String gitdir;
    @Argument(index=0, metaVar="metaVar_command", required=true, handler=SubcommandHandler.class)
    private TextBuiltin subcommand;
    @Argument(index=1, metaVar="metaVar_arg")
    private List<String> arguments = new ArrayList<String>();

    public static void main(String[] argv) {
        new Main().run(argv);
    }

    protected void run(String[] argv) {
        try {
            if (!Main.installConsole()) {
                AwtAuthenticator.install();
                AwtCredentialsProvider.install();
            }
            Main.configureHttpProxy();
            this.execute(argv);
        }
        catch (Die err) {
            System.err.println(MessageFormat.format(CLIText.get().fatalError, err.getMessage()));
            if (this.showStackTrace) {
                err.printStackTrace();
            }
            System.exit(128);
        }
        catch (Exception err) {
            if (err.getClass() == IOException.class) {
                if (err.getMessage().equals("Broken pipe")) {
                    System.exit(0);
                }
                if (err.getMessage().equals("The pipe is being closed")) {
                    System.exit(0);
                }
            }
            if (!this.showStackTrace && err.getCause() != null && err instanceof TransportException) {
                System.err.println(MessageFormat.format(CLIText.get().fatalError, err.getCause().getMessage()));
            }
            if (err.getClass().getName().startsWith("org.eclipse.jgit.errors.")) {
                System.err.println(MessageFormat.format(CLIText.get().fatalError, err.getMessage()));
                if (this.showStackTrace) {
                    err.printStackTrace();
                }
                System.exit(128);
            }
            err.printStackTrace();
            System.exit(1);
        }
        if (System.out.checkError()) {
            System.err.println(CLIText.get().unknownIoErrorStdout);
            System.exit(1);
        }
        if (System.err.checkError()) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String[] argv) throws Exception {
        TextBuiltin cmd;
        PrintWriter writer;
        CmdLineParser clp;
        block16: {
            clp = new CmdLineParser(this);
            writer = new PrintWriter(System.err);
            try {
                clp.parseArgument(argv);
            }
            catch (CmdLineException err) {
                if (argv.length <= 0 || this.help || this.version) break block16;
                writer.println(MessageFormat.format(CLIText.get().fatalError, err.getMessage()));
                writer.flush();
                System.exit(1);
            }
        }
        if (argv.length == 0 || this.help) {
            String ex = clp.printExample(ExampleMode.ALL, CLIText.get().resourceBundle());
            writer.println("jgit" + ex + " command [ARG ...]");
            if (this.help) {
                writer.println();
                clp.printUsage(writer, CLIText.get().resourceBundle());
                writer.println();
            } else if (this.subcommand == null) {
                writer.println();
                writer.println(CLIText.get().mostCommonlyUsedCommandsAre);
                CommandRef[] common = CommandCatalog.common();
                int width = 0;
                for (CommandRef c : common) {
                    width = Math.max(width, c.getName().length());
                }
                width += 2;
                for (CommandRef c : common) {
                    writer.print(' ');
                    writer.print(c.getName());
                    for (int i = c.getName().length(); i < width; ++i) {
                        writer.print(' ');
                    }
                    writer.print(CLIText.get().resourceBundle().getString(c.getUsage()));
                    writer.println();
                }
                writer.println();
            }
            writer.flush();
            System.exit(1);
        }
        if (this.version) {
            String cmdId = Version.class.getSimpleName().toLowerCase();
            this.subcommand = CommandCatalog.get(cmdId).create();
        }
        if ((cmd = this.subcommand).requiresRepository()) {
            cmd.init(this.openGitDir(this.gitdir), null);
        } else {
            cmd.init(null, this.gitdir);
        }
        try {
            cmd.execute(this.arguments.toArray(new String[this.arguments.size()]));
        }
        finally {
            if (cmd.outw != null) {
                cmd.outw.flush();
            }
        }
    }

    protected Repository openGitDir(String gitdir) throws IOException {
        RepositoryBuilder rb = (RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(gitdir != null ? new File(gitdir) : null)).readEnvironment()).findGitDir();
        if (rb.getGitDir() == null) {
            throw new Die(CLIText.get().cantFindGitDirectory);
        }
        return rb.build();
    }

    private static boolean installConsole() {
        try {
            Main.install("org.eclipse.jgit.console.ConsoleAuthenticator");
            Main.install("org.eclipse.jgit.console.ConsoleCredentialsProvider");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        catch (UnsupportedClassVersionError e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(CLIText.get().cannotSetupConsole, e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(CLIText.get().cannotSetupConsole, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CLIText.get().cannotSetupConsole, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(CLIText.get().cannotSetupConsole, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(CLIText.get().cannotSetupConsole, e);
        }
    }

    private static void install(String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        try {
            Class.forName(name).getMethod("install", new Class[0]).invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw e;
        }
    }

    private static void configureHttpProxy() throws MalformedURLException {
        String userpass;
        String s = System.getenv("http_proxy");
        if (s == null || s.equals("")) {
            return;
        }
        URL u = new URL(s.indexOf("://") == -1 ? "http://" + s : s);
        if (!"http".equals(u.getProtocol())) {
            throw new MalformedURLException(MessageFormat.format(CLIText.get().invalidHttpProxyOnlyHttpSupported, s));
        }
        String proxyHost = u.getHost();
        int proxyPort = u.getPort();
        System.setProperty("http.proxyHost", proxyHost);
        if (proxyPort > 0) {
            System.setProperty("http.proxyPort", String.valueOf(proxyPort));
        }
        if ((userpass = u.getUserInfo()) != null && userpass.contains(":")) {
            int c = userpass.indexOf(58);
            String user = userpass.substring(0, c);
            String pass = userpass.substring(c + 1);
            CachedAuthenticator.add((CachedAuthenticator.CachedAuthentication)new CachedAuthenticator.CachedAuthentication(proxyHost, proxyPort, user, pass));
        }
    }
}

