/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.auth;

import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jkube.kit.build.api.auth.RegistryAuthConfig;

public class AuthConfig {
    public static final AuthConfig EMPTY_AUTH_CONFIG = new AuthConfig("", "", "", "");
    private final String username;
    private final String password;
    private final String email;
    private final String auth;
    private String authEncoded;

    public AuthConfig(String username, String password, String email, String auth) {
        this.username = username;
        this.password = password;
        this.email = email;
        this.auth = auth;
        this.authEncoded = this.createAuthEncoded();
    }

    public String toHeaderValue() {
        return this.authEncoded;
    }

    private String createAuthEncoded() {
        JsonObject ret = new JsonObject();
        this.putNonNull(ret, "username", this.username);
        this.putNonNull(ret, "password", this.password);
        this.putNonNull(ret, "email", this.email);
        this.putNonNull(ret, "auth", this.auth);
        return this.encodeBase64ChunkedURLSafeString(ret.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static AuthConfig fromMap(Map<String, String> params) {
        return AuthConfig.builder().username(params.get("username")).password(params.get("password")).email(params.get("email")).auth(params.get("auth")).build();
    }

    public static AuthConfig fromCredentialsEncoded(String credentialsEncoded, String email) {
        String credentials = new String(Base64.decodeBase64((String)credentialsEncoded));
        String[] parsedCredentials = credentials.split(":", 2);
        return AuthConfig.builder().username(parsedCredentials[0]).password(parsedCredentials[1]).email(email).build();
    }

    public static AuthConfig fromRegistryAuthConfig(RegistryAuthConfig registryAuthConfig, RegistryAuthConfig.Kind kind, UnaryOperator<String> decryptor) {
        String password = registryAuthConfig.getPassword(kind);
        return AuthConfig.builder().username(registryAuthConfig.getUsername(kind)).email(registryAuthConfig.getEmail(kind)).auth(registryAuthConfig.getAuth(kind)).password(AuthConfig.decryptPassword(password, decryptor)).build();
    }

    public static String decryptPassword(String password, UnaryOperator<String> decryptor) {
        return Optional.ofNullable(decryptor).map(d -> (String)d.apply(password)).orElse(password);
    }

    private String encodeBase64ChunkedURLSafeString(byte[] binaryData) {
        return Base64.encodeBase64String((byte[])binaryData).replace('+', '-').replace('/', '_');
    }

    private void putNonNull(JsonObject ret, String key, String value) {
        if (value != null) {
            ret.addProperty(key, value);
        }
    }

    public static AuthConfigBuilder builder() {
        return new AuthConfigBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAuth() {
        return this.auth;
    }

    public String getAuthEncoded() {
        return this.authEncoded;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthConfig)) {
            return false;
        }
        AuthConfig other = (AuthConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$auth = this.getAuth();
        String other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        String this$authEncoded = this.getAuthEncoded();
        String other$authEncoded = other.getAuthEncoded();
        return !(this$authEncoded == null ? other$authEncoded != null : !this$authEncoded.equals(other$authEncoded));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        String $authEncoded = this.getAuthEncoded();
        result = result * 59 + ($authEncoded == null ? 43 : $authEncoded.hashCode());
        return result;
    }

    public static class AuthConfigBuilder {
        private String username;
        private String password;
        private String email;
        private String auth;

        AuthConfigBuilder() {
        }

        public AuthConfigBuilder username(String username) {
            this.username = username;
            return this;
        }

        public AuthConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        public AuthConfigBuilder email(String email) {
            this.email = email;
            return this;
        }

        public AuthConfigBuilder auth(String auth) {
            this.auth = auth;
            return this;
        }

        public AuthConfig build() {
            return new AuthConfig(this.username, this.password, this.email, this.auth);
        }

        public String toString() {
            return "AuthConfig.AuthConfigBuilder(username=" + this.username + ", password=" + this.password + ", email=" + this.email + ", auth=" + this.auth + ")";
        }
    }
}

