/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.config.property;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.config.property.ConfigKey;
import org.eclipse.jkube.kit.build.api.config.property.PropertyMode;
import org.eclipse.jkube.kit.build.api.config.property.ValueProvider;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.MapUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.WatchImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.HealthCheckConfiguration;

public class PropertyConfigResolver {
    private static final String DEFAULT_PREFIX = "jkube.container-image";
    private static final PropertyMode DEFAULT_MODE = PropertyMode.OVERRIDE;

    public final ImageConfiguration resolve(ImageConfiguration fromConfig, JavaProject project) {
        Properties properties = JKubeProjectUtil.getPropertiesWithSystemOverrides((JavaProject)project);
        String prefix = StringUtils.isBlank((CharSequence)fromConfig.getPropertyResolverPrefix()) ? DEFAULT_PREFIX : fromConfig.getPropertyResolverPrefix();
        ValueProvider valueProvider = new ValueProvider(prefix, properties, DEFAULT_MODE);
        return ImageConfiguration.builder().name(valueProvider.getString(ConfigKey.NAME, fromConfig.getName())).alias(valueProvider.getString(ConfigKey.ALIAS, fromConfig.getAlias())).registry(valueProvider.getString(ConfigKey.REGISTRY, fromConfig.getRegistry())).build(this.extractBuildConfiguration(fromConfig, valueProvider)).watch(this.extractWatchConfig(fromConfig, valueProvider)).build();
    }

    private static <T, R> R valueOr(T input, Function<T, R> function, R defaultValue) {
        return Optional.ofNullable(input).map(function).orElse(defaultValue);
    }

    private static <T, R> R valueOrNull(T input, Function<T, R> function) {
        return PropertyConfigResolver.valueOr(input, function, null);
    }

    private BuildConfiguration extractBuildConfiguration(ImageConfiguration fromConfig, ValueProvider valueProvider) {
        BuildConfiguration config = fromConfig.getBuild() != null ? fromConfig.getBuild() : new BuildConfiguration();
        return config.toBuilder().buildpacksBuilderImage(valueProvider.getString(ConfigKey.BUILDPACKS_BUILDER_IMAGE, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getBuildpacksBuilderImage))).cmd(this.extractArguments(valueProvider, ConfigKey.CMD, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getCmd))).cleanup(valueProvider.getString(ConfigKey.CLEANUP, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getCleanup))).nocache(valueProvider.getBoolean(ConfigKey.NOCACHE, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getNocache))).clearCacheFrom().cacheFrom(valueProvider.getList(ConfigKey.CACHEFROM, PropertyConfigResolver.valueOr(config, BuildConfiguration::getCacheFrom, Collections.emptyList()))).createImageOptions(valueProvider.getMap(ConfigKey.CREATE_IMAGE_OPTIONS, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getCreateImageOptions))).optimise(valueProvider.getBoolean(ConfigKey.OPTIMISE, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getOptimise))).entryPoint(this.extractArguments(valueProvider, ConfigKey.ENTRYPOINT, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getEntryPoint))).assembly(this.extractAssembly(PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getAssembly), valueProvider)).env(MapUtil.mergeMaps((Map[])new Map[]{valueProvider.getMap(ConfigKey.ENV_BUILD, Collections.emptyMap()), valueProvider.getMap(ConfigKey.ENV, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getEnv))})).args(valueProvider.getMap(ConfigKey.ARGS, PropertyConfigResolver.valueOr(config, BuildConfiguration::getArgs, Collections.emptyMap()))).labels(valueProvider.getMap(ConfigKey.LABELS, PropertyConfigResolver.valueOr(config, BuildConfiguration::getLabels, Collections.emptyMap()))).clearPorts().ports(this.extractPortValues(PropertyConfigResolver.valueOr(config, BuildConfiguration::getPorts, Collections.emptyList()), valueProvider)).shell(this.extractArguments(valueProvider, ConfigKey.SHELL, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getShell))).clearRunCmds().runCmds(valueProvider.getList(ConfigKey.RUN, PropertyConfigResolver.valueOr(config, BuildConfiguration::getRunCmds, Collections.emptyList()))).from(valueProvider.getString(ConfigKey.FROM, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getFrom))).fromExt(valueProvider.getMap(ConfigKey.FROM_EXT, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getFromExt))).clearVolumes().volumes(valueProvider.getList(ConfigKey.VOLUMES, PropertyConfigResolver.valueOr(config, BuildConfiguration::getVolumes, Collections.emptyList()))).clearTags().tags(valueProvider.getList(ConfigKey.TAGS, PropertyConfigResolver.valueOr(config, BuildConfiguration::getTags, Collections.emptyList()))).clearPlatforms().platforms(valueProvider.getList(ConfigKey.PLATFORMS, PropertyConfigResolver.valueOr(config, BuildConfiguration::getPlatforms, Collections.emptyList()))).maintainer(valueProvider.getString(ConfigKey.MAINTAINER, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getMaintainer))).workdir(valueProvider.getString(ConfigKey.WORKDIR, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getWorkdir))).skip(valueProvider.getBoolean(ConfigKey.SKIP, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getSkip))).imagePullPolicy(valueProvider.getString(ConfigKey.IMAGE_PULL_POLICY, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getImagePullPolicy))).contextDir(valueProvider.getString(ConfigKey.CONTEXT_DIR, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getContextDirRaw))).dockerArchive(valueProvider.getString(ConfigKey.DOCKER_ARCHIVE, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getDockerArchiveRaw))).dockerFile(valueProvider.getString(ConfigKey.DOCKER_FILE, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getDockerFileRaw))).buildOptions(valueProvider.getMap(ConfigKey.BUILD_OPTIONS, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getBuildOptions))).filter(valueProvider.getString(ConfigKey.FILTER, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getFilter))).user(valueProvider.getString(ConfigKey.USER, PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getUser))).healthCheck(this.extractHealthCheck(PropertyConfigResolver.valueOrNull(config, BuildConfiguration::getHealthCheck), valueProvider)).build();
    }

    private AssemblyConfiguration extractAssembly(AssemblyConfiguration originalConfig, ValueProvider valueProvider) {
        AssemblyConfiguration config = originalConfig != null ? originalConfig : new AssemblyConfiguration();
        return config.toBuilder().name(valueProvider.getString(ConfigKey.ASSEMBLY_NAME, PropertyConfigResolver.valueOrNull(originalConfig, AssemblyConfiguration::getName))).targetDir(valueProvider.getString(ConfigKey.ASSEMBLY_TARGET_DIR, PropertyConfigResolver.valueOrNull(originalConfig, AssemblyConfiguration::getTargetDir))).exportTargetDir(valueProvider.getBoolean(ConfigKey.ASSEMBLY_EXPORT_TARGET_DIR, PropertyConfigResolver.valueOrNull(originalConfig, AssemblyConfiguration::getExportTargetDir))).permissionsString(valueProvider.getString(ConfigKey.ASSEMBLY_PERMISSIONS, PropertyConfigResolver.valueOrNull(originalConfig, AssemblyConfiguration::getPermissionsRaw))).user(valueProvider.getString(ConfigKey.ASSEMBLY_USER, PropertyConfigResolver.valueOrNull(originalConfig, AssemblyConfiguration::getUser))).modeString(valueProvider.getString(ConfigKey.ASSEMBLY_MODE, PropertyConfigResolver.valueOrNull(originalConfig, AssemblyConfiguration::getModeRaw))).tarLongFileMode(valueProvider.getString(ConfigKey.ASSEMBLY_TARLONGFILEMODE, PropertyConfigResolver.valueOrNull(originalConfig, AssemblyConfiguration::getTarLongFileMode))).excludeFinalOutputArtifact(valueProvider.getBoolean(ConfigKey.ASSEMBLY_EXCLUDE_FINAL_OUTPUT_ARTIFACT, Optional.ofNullable(PropertyConfigResolver.valueOrNull(originalConfig, AssemblyConfiguration::isExcludeFinalOutputArtifact)).orElse(false)).booleanValue()).build();
    }

    private HealthCheckConfiguration extractHealthCheck(HealthCheckConfiguration originalConfig, ValueProvider valueProvider) {
        Map<String, String> healthCheckProperties = valueProvider.getMap(ConfigKey.HEALTHCHECK, Collections.emptyMap());
        if (healthCheckProperties != null && !healthCheckProperties.isEmpty()) {
            HealthCheckConfiguration config = originalConfig != null ? originalConfig : new HealthCheckConfiguration();
            return config.toBuilder().interval(valueProvider.getString(ConfigKey.HEALTHCHECK_INTERVAL, PropertyConfigResolver.valueOrNull(originalConfig, HealthCheckConfiguration::getInterval))).timeout(valueProvider.getString(ConfigKey.HEALTHCHECK_TIMEOUT, PropertyConfigResolver.valueOrNull(originalConfig, HealthCheckConfiguration::getTimeout))).startPeriod(valueProvider.getString(ConfigKey.HEALTHCHECK_START_PERIOD, PropertyConfigResolver.valueOrNull(originalConfig, HealthCheckConfiguration::getStartPeriod))).retries(valueProvider.getInteger(ConfigKey.HEALTHCHECK_RETRIES, PropertyConfigResolver.valueOrNull(originalConfig, HealthCheckConfiguration::getRetries))).modeString(valueProvider.getString(ConfigKey.HEALTHCHECK_MODE, originalConfig == null || originalConfig.getMode() == null ? null : originalConfig.getMode().name())).cmd(this.extractArguments(valueProvider, ConfigKey.HEALTHCHECK_CMD, PropertyConfigResolver.valueOrNull(originalConfig, HealthCheckConfiguration::getCmd))).build();
        }
        return originalConfig;
    }

    private Set<String> extractPortValues(List<String> config, ValueProvider valueProvider) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        List<String> ports = valueProvider.getList(ConfigKey.PORTS, config);
        if (ports == null) {
            return null;
        }
        List parsedPorts = EnvUtil.splitOnLastColon(ports);
        for (String[] port : parsedPorts) {
            ret.add(port[1]);
        }
        return ret;
    }

    private Arguments extractArguments(ValueProvider valueProvider, ConfigKey configKey, Arguments alternative) {
        return valueProvider.getObject(configKey, alternative, raw -> raw != null ? Arguments.builder().shell(raw).build() : null);
    }

    private WatchImageConfiguration extractWatchConfig(ImageConfiguration fromConfig, ValueProvider valueProvider) {
        WatchImageConfiguration config = fromConfig.getWatchConfiguration() != null ? fromConfig.getWatchConfiguration() : new WatchImageConfiguration();
        return config.toBuilder().interval(valueProvider.getInteger(ConfigKey.WATCH_INTERVAL, config.getIntervalRaw())).postGoal(valueProvider.getString(ConfigKey.WATCH_POSTGOAL, config.getPostGoal())).postExec(valueProvider.getString(ConfigKey.WATCH_POSTEXEC, config.getPostExec())).modeString(valueProvider.getString(ConfigKey.WATCH_MODE, config.getMode() == null ? null : config.getMode().name())).build();
    }
}

