/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.helper;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.JKubeFileInterpolator;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.Serialization;

public class DockerFileUtil {
    private static final String ARG_PATTERN_REGEX = "\\$([\\w|\\-\\.]+)|\\$\\{([\\w\\-|\\.]+)\\}";
    private static final Pattern argPattern = Pattern.compile("\\$([\\w|\\-\\.]+)|\\$\\{([\\w\\-|\\.]+)\\}");

    private DockerFileUtil() {
    }

    public static List<String> extractBaseImages(File dockerFile, Properties properties, String filter, Map<String, String> argsFromBuildConfig) throws IOException {
        List<String[]> fromLines = DockerFileUtil.extractLines(dockerFile, "FROM", properties, DockerFileUtil.resolveDockerfileFilter(filter));
        Map<String, String> args = DockerFileUtil.extractArgs(dockerFile, properties, filter, argsFromBuildConfig);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        HashSet<String> fromAlias = new HashSet<String>();
        for (String[] fromLine : fromLines) {
            if (fromLine.length == 2) {
                result.add(DockerFileUtil.resolveImageTagFromArgs(fromLine[1], args));
                continue;
            }
            if (fromLine.length != 4) continue;
            if (!fromAlias.contains(fromLine[1])) {
                result.add(DockerFileUtil.resolveImageTagFromArgs(fromLine[1], args));
            }
            fromAlias.add(DockerFileUtil.resolveImageTagFromArgs(fromLine[3], args));
        }
        return new ArrayList<String>(result);
    }

    public static Map<String, String> extractArgs(File dockerfile, Properties properties, String filter, Map<String, String> argsFromBuildConfig) throws IOException {
        return DockerFileUtil.extractArgsFromLines(DockerFileUtil.extractLines(dockerfile, "ARG", properties, filter), argsFromBuildConfig);
    }

    public static List<String[]> extractLines(File dockerFile, String keyword, Properties properties, String filter) throws IOException {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String lineInterpolated = JKubeFileInterpolator.interpolate((String)line, (Properties)properties, (String)filter);
                String[] lineParts = lineInterpolated.split("\\s+");
                if (lineParts.length <= 0 || !lineParts[0].equalsIgnoreCase(keyword)) continue;
                ret.add(lineParts);
            }
        }
        return ret;
    }

    public static String interpolate(File dockerFile, Properties properties, String filter) throws IOException {
        return JKubeFileInterpolator.interpolate((File)dockerFile, (Properties)properties, (String)filter);
    }

    protected static Map<String, String> extractArgsFromLines(List<String[]> argLines, Map<String, String> argsFromBuildConfig) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String[] argLine : argLines) {
            if (argLine.length <= 1) continue;
            DockerFileUtil.updateMapWithArgValue(result, argsFromBuildConfig, argLine[1]);
        }
        return result;
    }

    static String resolveImageTagFromArgs(String imageTagString, Map<String, String> args) {
        String resolvedImageString = imageTagString;
        Set<String> foundArgs = DockerFileUtil.findAllArgs(imageTagString);
        for (String foundArg : foundArgs) {
            if (!args.containsKey(foundArg)) continue;
            resolvedImageString = resolvedImageString.replaceFirst(String.format("\\$\\{*%s\\}*", foundArg), args.get(foundArg));
        }
        return resolvedImageString;
    }

    static Set<String> findAllArgs(String imageTagString) {
        Matcher m = argPattern.matcher(imageTagString);
        HashSet<String> args = new HashSet<String>();
        while (m.find()) {
            if (m.group(1) != null) {
                args.add(m.group(1));
                continue;
            }
            if (m.group(2) == null) continue;
            args.add(m.group(2));
        }
        return args;
    }

    public static Map<String, Object> readDockerConfig() {
        String dockerConfigDirectory = EnvUtil.getEnv((String)"DOCKER_CONFIG");
        File dockerConfig = StringUtils.isNotBlank((CharSequence)dockerConfigDirectory) ? new File(dockerConfigDirectory, "config.json") : new File(EnvUtil.getUserHome(), ".docker/config.json");
        if (!dockerConfig.exists() || !dockerConfig.isFile()) {
            return Collections.emptyMap();
        }
        try {
            return (Map)Serialization.unmarshal((File)dockerConfig, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read docker config from " + dockerConfig.getAbsolutePath(), e);
        }
    }

    private static void updateMapWithArgValue(Map<String, String> result, Map<String, String> args, String argString) {
        if (argString.contains("=") || argString.contains(":")) {
            String[] argStringParts = argString.split("[=:]");
            String argStringKey = argStringParts[0];
            String argStringValue = DockerFileUtil.determineFinalArgValue(argString, argStringParts, args);
            if (argStringValue.startsWith("\"") || argStringValue.startsWith("'")) {
                argStringValue = argStringValue.replaceAll("(^[\"'])|([\"']$)", "");
            } else {
                DockerFileUtil.validateArgValue(argStringValue);
            }
            result.put(argStringKey, argStringValue);
        } else {
            DockerFileUtil.validateArgValue(argString);
            result.putAll(DockerFileUtil.fetchArgsFromBuildConfiguration(argString, args));
        }
    }

    private static String determineFinalArgValue(String argString, String[] argStringParts, Map<String, String> args) {
        String argStringValue = argString.substring(argStringParts[0].length() + 1);
        if (args == null || args.get(argStringParts[0]) == null) {
            return argStringValue;
        }
        return args.getOrDefault(argStringParts[0], argStringValue);
    }

    private static Map<String, String> fetchArgsFromBuildConfiguration(String argString, Map<String, String> args) {
        HashMap<String, String> argFromBuildConfig = new HashMap<String, String>();
        if (args != null) {
            argFromBuildConfig.put(argString, args.getOrDefault(argString, ""));
        }
        return argFromBuildConfig;
    }

    private static void validateArgValue(String argStringParam) {
        String[] argStringParts = argStringParam.split("\\s+");
        if (argStringParts.length > 1) {
            throw new IllegalArgumentException("Dockerfile parse error: ARG requires exactly one argument. Provided : " + argStringParam);
        }
    }

    static String resolveDockerfileFilter(String filter) {
        return filter != null ? filter : "${*}";
    }
}

