/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.service.buildpacks;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.IoUtil;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;
import org.eclipse.jkube.kit.common.util.SemanticVersionUtil;
import org.eclipse.jkube.kit.service.buildpacks.BuildPackCommand;

public class BuildPackCliDownloader {
    private static final String JKUBE_PACK_DIR = ".jkube";
    private static final String PACK_UNIX_CLI_NAME = "pack";
    private static final String PACK_DEFAULT_CLI_VERSION_PROPERTY = "version";
    private static final String PACK_CLI_LINUX_ARTIFACT = "linux.artifact";
    private static final String PACK_CLI_LINUX_ARM64_ARTIFACT = "linux-arm64.artifact";
    private static final String PACK_CLI_MACOS_ARTIFACT = "macos.artifact";
    private static final String PACK_CLI_MACOS_ARM64_ARTIFACT = "macos-arm64.artifact";
    private static final String PACK_CLI_WINDOWS_ARTIFACT = "windows.artifact";
    private final KitLogger kitLogger;
    private final String packCliVersion;
    private final Properties packProperties;
    private final File jKubeUserHomeDir;

    public BuildPackCliDownloader(KitLogger kitLogger) {
        this(kitLogger, null);
    }

    public BuildPackCliDownloader(KitLogger kitLogger, Properties packProperties) {
        this.kitLogger = kitLogger;
        this.packProperties = packProperties != null ? packProperties : PropertiesUtil.getPropertiesFromResource((URL)BuildPackCliDownloader.class.getResource("/META-INF/jkube/pack-cli.properties"));
        this.packCliVersion = this.packProperties.getProperty(PACK_DEFAULT_CLI_VERSION_PROPERTY);
        this.jKubeUserHomeDir = new File(EnvUtil.getUserHome(), JKUBE_PACK_DIR);
    }

    public File getPackCLIIfPresentOrDownload() {
        try {
            File pack = this.resolveBinaryLocation().toFile();
            if (!pack.exists() || !this.isValid(pack)) {
                this.downloadPackCli();
            }
            return pack;
        }
        catch (IOException ioException) {
            this.kitLogger.warn("Not able to download pack CLI : " + ioException.getMessage(), new Object[0]);
            this.kitLogger.info("Checking for local pack CLI", new Object[0]);
            return this.getLocalPackCLI();
        }
    }

    private void downloadPackCli() throws IOException {
        File tempDownloadDirectory = FileUtil.createTempDirectory();
        FileUtil.createDirectory((File)this.jKubeUserHomeDir);
        URL downloadUrl = new URL(this.inferApplicableDownloadArtifactUrl());
        Path packInJKubeDir = this.resolveBinaryLocation();
        this.kitLogger.info("Downloading pack CLI %s", new Object[]{this.packCliVersion});
        IoUtil.downloadArchive((URL)downloadUrl, (File)tempDownloadDirectory);
        File packInExtractedArchive = new File(tempDownloadDirectory, packInJKubeDir.toFile().getName());
        if (!packInExtractedArchive.exists()) {
            throw new IllegalStateException("Unable to find " + packInJKubeDir.toFile().getName() + " in downloaded artifact");
        }
        if (!packInExtractedArchive.canExecute() && !packInExtractedArchive.setExecutable(true)) {
            throw new IllegalStateException("Failure in setting execute permission in " + packInExtractedArchive.getAbsolutePath());
        }
        Files.copy(packInExtractedArchive.toPath(), packInJKubeDir, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        FileUtil.cleanDirectory((File)tempDownloadDirectory);
    }

    private String inferApplicableDownloadArtifactUrl() {
        boolean isProcessorArchitectureArm = EnvUtil.getProcessorArchitecture().equals("aarch64");
        if (EnvUtil.isWindows()) {
            return (String)this.packProperties.get(PACK_CLI_WINDOWS_ARTIFACT);
        }
        if (EnvUtil.isMacOs() && isProcessorArchitectureArm) {
            return (String)this.packProperties.get(PACK_CLI_MACOS_ARM64_ARTIFACT);
        }
        if (EnvUtil.isMacOs()) {
            return (String)this.packProperties.get(PACK_CLI_MACOS_ARTIFACT);
        }
        if (isProcessorArchitectureArm) {
            return (String)this.packProperties.get(PACK_CLI_LINUX_ARM64_ARTIFACT);
        }
        return (String)this.packProperties.get(PACK_CLI_LINUX_ARTIFACT);
    }

    private File getLocalPackCLI() {
        File packCliFoundOnUserPath = this.checkPackCLIPresentOnMachine();
        if (packCliFoundOnUserPath == null) {
            throw new IllegalStateException("No local pack binary found");
        }
        return packCliFoundOnUserPath;
    }

    private File checkPackCLIPresentOnMachine() {
        File packCliFoundOnUserPath = EnvUtil.findBinaryFileInUserPath((String)this.resolveBinaryLocation().toFile().getName());
        if (packCliFoundOnUserPath != null && this.isValid(packCliFoundOnUserPath)) {
            return packCliFoundOnUserPath;
        }
        return null;
    }

    public boolean isValid(File packCli) {
        AtomicReference versionRef = new AtomicReference();
        BuildPackCommand versionCommand = new BuildPackCommand(this.kitLogger, packCli, Collections.singletonList("--version"), versionRef::set);
        try {
            versionCommand.execute();
            String version = SemanticVersionUtil.removeBuildMetadata((String)((String)versionRef.get()));
            return StringUtils.isNotBlank((CharSequence)version) && this.packCliVersion.equals(version);
        }
        catch (IOException e) {
            return false;
        }
    }

    private Path resolveBinaryLocation() {
        String binaryName = PACK_UNIX_CLI_NAME;
        if (EnvUtil.isWindows()) {
            binaryName = "pack." + this.packProperties.getProperty("windows.binary-extension");
        }
        return this.jKubeUserHomeDir.toPath().resolve(binaryName);
    }
}

