/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.access.hc;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.eclipse.jkube.kit.build.service.docker.access.chunked.EntityStreamReaderUtil;

class HcChunkedResponseHandlerWrapper
implements ResponseHandler<Object> {
    private final EntityStreamReaderUtil.JsonEntityResponseHandler handler;

    HcChunkedResponseHandlerWrapper(EntityStreamReaderUtil.JsonEntityResponseHandler handler) {
        this.handler = handler;
    }

    public Object handleResponse(HttpResponse response) throws IOException {
        if (!(HcChunkedResponseHandlerWrapper.hasJsonContentType(response) || HcChunkedResponseHandlerWrapper.hasTextPlainContentType(response) || HcChunkedResponseHandlerWrapper.hasNoContentTypeAsForPodman(response))) {
            throw new IllegalStateException("Docker daemon returned an unexpected content type while trying to build the Dockerfile.\nStatus: " + response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase());
        }
        try (InputStream stream = response.getEntity().getContent();){
            EntityStreamReaderUtil.processJsonStream(this.handler, stream);
        }
        return null;
    }

    private static Function<HttpResponse, Boolean> isContentType(String contentType) {
        return response -> Stream.of(response.getAllHeaders()).filter(h -> h.getName().equalsIgnoreCase("Content-Type")).anyMatch(h -> h.getValue().toLowerCase().startsWith(contentType));
    }

    private static boolean hasJsonContentType(HttpResponse response) {
        return HcChunkedResponseHandlerWrapper.isContentType("application/json").apply(response);
    }

    private static boolean hasTextPlainContentType(HttpResponse response) {
        return HcChunkedResponseHandlerWrapper.isContentType("text/plain").apply(response);
    }

    private static boolean hasNoContentTypeAsForPodman(HttpResponse response) {
        return Stream.of(response.getAllHeaders()).noneMatch(h -> h.getName().equalsIgnoreCase("Content-Type"));
    }
}

