/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.wait;

import org.eclipse.jkube.kit.build.api.model.ContainerDetails;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;
import org.eclipse.jkube.kit.build.service.docker.wait.WaitChecker;
import org.eclipse.jkube.kit.common.KitLogger;

public class HealthCheckChecker
implements WaitChecker {
    private boolean first = true;
    private final DockerAccess docker;
    private final String containerId;
    private final KitLogger log;
    private final String imageConfigDesc;

    public HealthCheckChecker(DockerAccess docker, String containerId, String imageConfigDesc, KitLogger log) {
        this.docker = docker;
        this.containerId = containerId;
        this.imageConfigDesc = imageConfigDesc;
        this.log = log;
    }

    @Override
    public boolean check() {
        try {
            ContainerDetails container = this.docker.getContainer(this.containerId);
            if (container == null) {
                this.log.debug("HealthWaitChecker: Container %s not found", new Object[0]);
                return false;
            }
            if (container.getHealthcheck() == null) {
                throw new IllegalArgumentException("Can not wait for healthstate of " + this.imageConfigDesc + ". No HEALTHCHECK configured.");
            }
            if (this.first) {
                this.log.info("%s: Waiting to become healthy", new Object[]{this.imageConfigDesc});
                this.log.debug("HealthWaitChecker: Waiting for healthcheck: '%s'", new Object[]{container.getHealthcheck()});
                this.first = false;
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("HealthWaitChecker: Waiting on healthcheck '%s'", new Object[]{container.getHealthcheck()});
            }
            return container.isHealthy();
        }
        catch (DockerAccessException e) {
            this.log.warn("Error while checking health: %s", new Object[]{e.getMessage()});
            return false;
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public String getLogLabel() {
        try {
            ContainerDetails container = this.docker.getContainer(this.containerId);
            return String.format("on healthcheck '%s'", container != null ? container.getHealthcheck() : "[container not found]");
        }
        catch (DockerAccessException e) {
            return String.format("on healthcheck [error fetching container: %s]", e.getMessage());
        }
    }
}

