/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.jkube.kit.build.api.helper.BuildArgResolverUtil;
import org.eclipse.jkube.kit.build.api.helper.BuildUtil;
import org.eclipse.jkube.kit.build.api.helper.DockerFileUtil;
import org.eclipse.jkube.kit.build.service.docker.ArchiveService;
import org.eclipse.jkube.kit.build.service.docker.ImagePullManager;
import org.eclipse.jkube.kit.build.service.docker.QueryService;
import org.eclipse.jkube.kit.build.service.docker.RegistryService;
import org.eclipse.jkube.kit.build.service.docker.access.BuildOptions;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.CleanupMode;

public class BuildService {
    private final DockerAccess docker;
    private final QueryService queryService;
    private final ArchiveService archiveService;
    private final RegistryService registryService;
    private final KitLogger log;

    BuildService(DockerAccess docker, QueryService queryService, RegistryService registryService, ArchiveService archiveService, KitLogger log) {
        this.docker = docker;
        this.queryService = queryService;
        this.registryService = registryService;
        this.archiveService = archiveService;
        this.log = log;
    }

    public void buildImage(ImageConfiguration imageConfig, ImagePullManager imagePullManager, JKubeConfiguration configuration) throws IOException {
        Map mergedBuildArgs = BuildArgResolverUtil.mergeBuildArgsIncludingLocalDockerConfigProxySettings((ImageConfiguration)imageConfig, (JKubeConfiguration)configuration);
        if (imagePullManager != null) {
            this.autoPullBaseImage(imageConfig, imagePullManager, configuration, mergedBuildArgs);
        }
        this.buildImage(imageConfig, configuration, this.checkForNocache(imageConfig), mergedBuildArgs);
    }

    public void tagImage(String imageName, ImageConfiguration imageConfig) throws DockerAccessException {
        List tags = imageConfig.getBuildConfiguration().getTags();
        if (!tags.isEmpty()) {
            this.log.info("%s: Tag with %s", new Object[]{imageConfig.getDescription(), String.join((CharSequence)",", tags)});
            for (String tag : tags) {
                if (tag == null) continue;
                this.docker.tag(imageName, new ImageName(imageName, tag).getFullName(), true);
            }
            this.log.debug("Tagging image successful!", new Object[0]);
        }
    }

    protected void buildImage(ImageConfiguration imageConfig, JKubeConfiguration params, boolean noCache, Map<String, String> buildArgs) throws IOException {
        String imageName = imageConfig.getName();
        ImageName.validate((String)imageName);
        BuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
        String oldImageId = null;
        CleanupMode cleanupMode = buildConfig.cleanupMode();
        if (cleanupMode.isRemove()) {
            oldImageId = this.queryService.getImageId(imageName);
        }
        long time = System.currentTimeMillis();
        if (buildConfig.getDockerArchive() != null) {
            this.docker.loadImage(imageName, buildConfig.getAbsoluteDockerTarPath(params.getSourceDirectory(), params.getProject().getBaseDirectory() != null ? params.getProject().getBaseDirectory().toString() : null));
            this.log.info("%s: Loaded tarball in %s", new Object[]{buildConfig.getDockerArchive(), EnvUtil.formatDurationTill((long)time)});
            return;
        }
        File dockerArchive = this.archiveService.createArchive(imageName, buildConfig, params, this.log);
        this.log.info("%s: Created %s in %s", new Object[]{imageConfig.getDescription(), dockerArchive.getName(), EnvUtil.formatDurationTill((long)time)});
        BuildOptions opts = new BuildOptions(buildConfig.getBuildOptions()).dockerfile(this.getDockerfileName(buildConfig)).forceRemove(cleanupMode.isRemove()).noCache(noCache).cacheFrom(buildConfig.getCacheFrom()).buildArgs(buildArgs);
        String newImageId = this.doBuildImage(imageName, dockerArchive, opts);
        if (newImageId == null) {
            throw new IllegalStateException("Failure in building image, unable to find image built with name " + imageName);
        }
        this.log.info("%s: Built image %s", new Object[]{imageConfig.getDescription(), newImageId});
        if (oldImageId != null && !oldImageId.equals(newImageId)) {
            try {
                this.docker.removeImage(oldImageId, true);
                this.log.info("%s: Removed old image %s", new Object[]{imageConfig.getDescription(), oldImageId});
            }
            catch (DockerAccessException exp) {
                if (cleanupMode == CleanupMode.TRY_TO_REMOVE) {
                    this.log.warn("%s: %s (old image)%s", new Object[]{imageConfig.getDescription(), exp.getMessage(), exp.getCause() != null ? " [" + exp.getCause().getMessage() + "]" : ""});
                }
                throw exp;
            }
        }
    }

    private String getDockerfileName(BuildConfiguration buildConfig) {
        if (buildConfig.isDockerFileMode()) {
            return buildConfig.getDockerFile().getName();
        }
        return null;
    }

    private String doBuildImage(String imageName, File dockerArchive, BuildOptions options) throws DockerAccessException {
        this.docker.buildImage(imageName, dockerArchive, options);
        return this.queryService.getImageId(imageName);
    }

    private void autoPullBaseImage(ImageConfiguration imageConfig, ImagePullManager imagePullManager, JKubeConfiguration configuration, Map<String, String> mergedBuildArgs) throws IOException {
        List<Object> fromImages;
        BuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
        if (buildConfig.getDockerArchive() != null) {
            return;
        }
        if (buildConfig.isDockerFileMode()) {
            fromImages = this.extractBaseFromDockerfile(buildConfig, configuration, mergedBuildArgs);
        } else {
            fromImages = new LinkedList();
            String baseImage = BuildUtil.extractBaseFromConfiguration((BuildConfiguration)buildConfig);
            if (baseImage != null) {
                fromImages.add(baseImage);
            }
        }
        for (String string : fromImages) {
            if (string == null || "scratch".equals(string)) continue;
            this.registryService.pullImageWithPolicy(string, imagePullManager, configuration.getPullRegistryConfig(), buildConfig);
        }
    }

    private List<String> extractBaseFromDockerfile(BuildConfiguration buildConfig, JKubeConfiguration configuration, Map<String, String> mergedBuildArgs) {
        List fromImage;
        try {
            File fullDockerFilePath = buildConfig.getAbsoluteDockerFilePath(configuration.getSourceDirectory(), (String)Optional.ofNullable(configuration.getProject().getBaseDirectory()).map(File::toString).orElse(null));
            fromImage = DockerFileUtil.extractBaseImages((File)fullDockerFilePath, (Properties)configuration.getProperties(), (String)buildConfig.getFilter(), mergedBuildArgs);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return fromImage;
    }

    private boolean checkForNocache(ImageConfiguration imageConfig) {
        String nocache = System.getProperty("docker.nocache");
        if (nocache != null) {
            return nocache.length() == 0 || Boolean.parseBoolean(nocache);
        }
        BuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
        return buildConfig.nocache();
    }
}

