/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.config.handler.compose;

import java.io.File;
import java.io.IOException;
import org.eclipse.jkube.kit.build.service.docker.helper.DockerPathUtil;

class ComposeUtils {
    private ComposeUtils() {
    }

    static File resolveComposeFileAbsolutely(String baseDir, String composeFile, String projectAbsolutePath) {
        File yamlFile = new File(composeFile);
        if (yamlFile.isAbsolute()) {
            return yamlFile;
        }
        File toCanonicalize = new File(ComposeUtils.resolveAbsolutely(baseDir, projectAbsolutePath), composeFile);
        try {
            return toCanonicalize.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to canonicalize the resolved docker-compose file path '" + toCanonicalize + "'");
        }
    }

    static File resolveAbsolutely(String pathToResolve, String absolutePath) {
        return DockerPathUtil.resolveAbsolutely(pathToResolve, absolutePath);
    }
}

