/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.archive;

import java.io.File;
import java.util.Objects;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFile;

public class AssemblyFileUtils {
    private AssemblyFileUtils() {
    }

    public static File getAssemblyFileOutputDirectory(AssemblyFile assemblyFile, File outputDirectoryForRelativePaths, AssemblyConfiguration assemblyConfiguration) {
        Objects.requireNonNull(assemblyFile.getOutputDirectory(), "Assembly Configuration output dir is required");
        File outputDirectory = assemblyFile.getOutputDirectory().isAbsolute() ? assemblyFile.getOutputDirectory() : new File(outputDirectoryForRelativePaths, Objects.requireNonNull(assemblyConfiguration.getTargetDir(), "Assembly Configuration target dir is required")).toPath().resolve(assemblyFile.getOutputDirectory().toPath()).toFile();
        return outputDirectory;
    }

    public static File resolveSourceFile(File baseDirectory, AssemblyFile assemblyFile) {
        return baseDirectory.toPath().resolve(Objects.requireNonNull(assemblyFile.getSource(), "Assembly File source is required").toPath()).toFile();
    }
}

