/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Dependency;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.Plugin;
import org.eclipse.jkube.kit.common.util.ClassUtil;

public class JKubeProjectUtil {
    public static final int MAX_RESOURCE_NAME_LENGTH = 63;

    private JKubeProjectUtil() {
    }

    public static <T> Optional<T> iterateOverListWithCondition(List<T> dependencyList, Predicate<? super T> condition) {
        if (dependencyList == null) {
            return Optional.empty();
        }
        return dependencyList.stream().filter(Objects::nonNull).filter(condition).findFirst();
    }

    public static String getAnyDependencyVersionWithGroupId(JavaProject jkubeProject, String groupId) {
        Optional<Dependency> value = JKubeProjectUtil.iterateOverListWithCondition(jkubeProject.getDependencies(), dependency -> dependency.getGroupId().equals(groupId));
        return value.map(Dependency::getVersion).orElse(null);
    }

    public static Plugin getPlugin(JavaProject javaProject, String groupId, String artifactId) {
        Optional<Plugin> value = JKubeProjectUtil.iterateOverListWithCondition(javaProject.getPlugins(), plugin -> plugin.getGroupId().equals(groupId) && plugin.getArtifactId().equals(artifactId));
        return value.orElse(null);
    }

    public static Plugin getPlugin(JavaProject jkubeProject, String artifactId) {
        Optional<Plugin> value = JKubeProjectUtil.iterateOverListWithCondition(jkubeProject.getPlugins(), plugin -> plugin.getArtifactId().equals(artifactId));
        return value.orElse(null);
    }

    public static boolean hasPlugin(JavaProject jkubeProject, String groupId, String artifactId) {
        return JKubeProjectUtil.getPlugin(jkubeProject, groupId, artifactId) != null;
    }

    public static boolean hasPluginOfAnyArtifactId(JavaProject jkubeProject, String artifactId) {
        return JKubeProjectUtil.getPlugin(jkubeProject, artifactId) != null;
    }

    public static boolean hasDependency(JavaProject jkubeProject, String groupId, String artifactId) {
        return JKubeProjectUtil.getDependency(jkubeProject, groupId, artifactId) != null;
    }

    public static boolean hasDependencyWithGroupId(JavaProject project, String groupId) {
        return Optional.ofNullable(project).map(JavaProject::getDependencies).map(deps -> deps.stream().anyMatch(dep -> Objects.equals(dep.getGroupId(), groupId))).orElse(false);
    }

    public static Dependency getDependency(JavaProject jkubeProject, String groupId, String artifactId) {
        List<Dependency> dependencyList = jkubeProject.getDependencies();
        if (dependencyList != null) {
            return JKubeProjectUtil.iterateOverListWithCondition(dependencyList, dependency -> Objects.equals(dependency.getGroupId(), groupId) && Objects.equals(dependency.getArtifactId(), artifactId)).orElse(null);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasResource(JavaProject project, String ... paths) throws IOException {
        try (URLClassLoader compileClassLoader = JKubeProjectUtil.getClassLoader(project);){
            String[] stringArray = paths;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (compileClassLoader.getResource(path) != null) {
                    boolean bl = true;
                    return bl;
                }
                ++n2;
            }
            return false;
        }
        catch (NullPointerException e) {
            throw new IOException("Path to resource was null", e);
        }
    }

    public static Properties getPropertiesWithSystemOverrides(JavaProject project) {
        Properties properties = new Properties(project.getProperties());
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    public static File getFinalOutputArtifact(JavaProject jkubeProject) {
        String nameOfFinalArtifact = jkubeProject.getBuildFinalName() == null ? String.format("%s-%s.%s", jkubeProject.getArtifactId(), jkubeProject.getVersion(), jkubeProject.getPackaging()) : String.format("%s.%s", jkubeProject.getBuildFinalName(), jkubeProject.getPackaging());
        File finalArtifact = new File(jkubeProject.getBuildDirectory(), nameOfFinalArtifact);
        return finalArtifact.exists() ? finalArtifact : null;
    }

    public static String createDefaultResourceName(String artifactId, String ... suffixes) {
        String suffix = StringUtils.join((Object[])suffixes, (String)"-");
        String ret = artifactId + (suffix.length() > 0 ? "-" + suffix : "");
        if (ret.length() > 63) {
            ret = ret.substring(0, 63);
        }
        return ret.toLowerCase();
    }

    public static URLClassLoader getClassLoader(JavaProject jKubeProject) {
        return ClassUtil.createClassLoader(jKubeProject.getCompileClassPathElements(), jKubeProject.getOutputDirectory().getAbsolutePath());
    }
}

