/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class LazyBuilder<T> {
    private final AtomicReference<T> instance = new AtomicReference();
    private final Supplier<T> build;

    public LazyBuilder(Supplier<T> build) {
        this.build = build;
    }

    public T get() {
        T result = this.instance.get();
        if (result == null && !this.instance.compareAndSet(null, result = this.build.get())) {
            return this.instance.get();
        }
        return result;
    }

    public boolean hasInstance() {
        return this.instance.get() != null;
    }
}

