/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserConfigurationCompare {
    private static final Logger LOG = LoggerFactory.getLogger(UserConfigurationCompare.class);
    protected static final Set<String> ignoredProperties = new HashSet<String>(Collections.singletonList("status"));

    private UserConfigurationCompare() {
    }

    public static boolean configEqual(Object entity1, Object entity2) {
        if (entity1 == entity2) {
            return true;
        }
        if (entity1 == null || entity2 == null) {
            return false;
        }
        if (entity1 instanceof Map || entity2 instanceof Map) {
            return UserConfigurationCompare.configEqualMap(UserConfigurationCompare.castTo(Map.class, entity1), UserConfigurationCompare.castTo(Map.class, entity2));
        }
        if (entity1 instanceof ObjectMeta || entity2 instanceof ObjectMeta) {
            return UserConfigurationCompare.configEqualObjectMeta(UserConfigurationCompare.castTo(ObjectMeta.class, entity1), UserConfigurationCompare.castTo(ObjectMeta.class, entity2));
        }
        if (entity1 instanceof Collection && entity2 instanceof Collection) {
            return UserConfigurationCompare.collectionsEqual((Collection)entity1, (Collection)entity2);
        }
        Class aClass = UserConfigurationCompare.getCommonDenominator(entity1.getClass(), entity2.getClass());
        if (aClass != null) {
            Object castEntity2 = UserConfigurationCompare.castTo(aClass, entity2);
            if (castEntity2 == null) {
                return false;
            }
            if (aClass.getPackage().getName().startsWith("org.eclipse.jkube")) {
                return UserConfigurationCompare.configEqualKubernetesDTO(entity1, entity2, aClass);
            }
        }
        return Objects.equals(entity1, entity2);
    }

    static <L, R> boolean collectionsEqual(Collection<L> left, Collection<R> right) {
        return UserConfigurationCompare.subCollection(left, right) && UserConfigurationCompare.subCollection(right, left);
    }

    static <L, R> boolean itemExists(L item, Collection<R> collection) {
        for (R candidate : collection) {
            if (!UserConfigurationCompare.configEqual(item, candidate)) continue;
            return true;
        }
        return false;
    }

    static <L, R> boolean subCollection(Collection<L> left, Collection<R> right) {
        for (L candidate : left) {
            if (UserConfigurationCompare.itemExists(candidate, right)) continue;
            return false;
        }
        return true;
    }

    static Class getCommonDenominator(Class left, Class right) {
        if (left.equals(right)) {
            return left;
        }
        if (left.isAssignableFrom(right)) {
            return UserConfigurationCompare.getCommonDenominator(left, right.getSuperclass());
        }
        if (right.isAssignableFrom(left)) {
            return UserConfigurationCompare.getCommonDenominator(left.getSuperclass(), right);
        }
        return null;
    }

    protected static boolean configEqualKubernetesDTO(@NotNull Object entity1, @NotNull Object entity2, @NotNull Class<?> clazz) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            LOG.warn("Failed to get beanInfo for " + clazz.getName() + ". " + e, (Throwable)e);
            return false;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method readMethod;
                String name = propertyDescriptor.getName();
                if (ignoredProperties.contains(name) || (readMethod = propertyDescriptor.getReadMethod()) == null) continue;
                Object value1 = UserConfigurationCompare.invokeMethod(entity1, readMethod);
                Object value2 = UserConfigurationCompare.invokeMethod(entity2, readMethod);
                if (value1 == null || value2 == null || UserConfigurationCompare.configEqual(value1, value2)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static Object invokeMethod(@NotNull Object entity, Method readMethod) throws InvocationTargetException, IllegalAccessException {
        try {
            return readMethod.invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to invoke method " + readMethod + " on " + entity + ". " + e, (Throwable)e);
            throw e;
        }
    }

    protected static boolean configEqualObjectMeta(ObjectMeta entity1, ObjectMeta entity2) {
        if (entity1 == entity2) {
            return true;
        }
        if (entity1 == null || entity2 == null) {
            return false;
        }
        return Objects.equals(entity1.getName(), entity2.getName()) && Objects.equals(entity1.getNamespace(), entity2.getNamespace()) && UserConfigurationCompare.configEqualMap(entity1.getLabels(), entity2.getLabels()) && UserConfigurationCompare.configEqualMap(entity1.getAnnotations(), entity2.getAnnotations());
    }

    private static <T> T castTo(Class<T> clazz, Object entity) {
        if (clazz.isInstance(entity)) {
            return clazz.cast(entity);
        }
        if (entity != null) {
            LOG.warn("Invalid class {} when expecting {} for instance: {}", new Object[]{entity.getClass().getName(), clazz.getName(), entity});
        }
        return null;
    }

    protected static boolean configEqualMap(Map entity1, Map entity2) {
        int size2;
        if (entity1 == entity2) {
            return true;
        }
        if (entity1 == null || entity2 == null) {
            return false;
        }
        int size1 = UserConfigurationCompare.size(entity1);
        if (size1 != (size2 = UserConfigurationCompare.size(entity2))) {
            return false;
        }
        Set entries = entity1.entrySet();
        for (Map.Entry entry : entries) {
            Object value2;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (UserConfigurationCompare.configEqual(value, value2 = entity2.get(key))) continue;
            return false;
        }
        return true;
    }

    protected static int size(Map map) {
        return map == null ? 0 : map.size();
    }

    protected static int size(Collection coll) {
        return coll == null ? 0 : coll.size();
    }
}

