/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.access;

import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextBuilder;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;

public class ClusterConfiguration
implements Serializable {
    private static final String PROPERTY_PREFIX = "jkube.";
    private static final long serialVersionUID = 8756257530678486528L;
    private String username;
    private String password;
    private String masterUrl;
    private String apiVersion;
    private String namespace;
    private String caCertFile;
    private String caCertData;
    private String clientCertFile;
    private String clientCertData;
    private String clientKeyFile;
    private String clientKeyData;
    private String clientKeyAlgo;
    private String clientKeyPassphrase;
    private String currentContext;
    private String trustStoreFile;
    private String trustStorePassphrase;
    private String keyStoreFile;
    private String keyStorePassphrase;
    private Boolean trustCerts;

    public String getNamespace() {
        return Optional.ofNullable(this.namespace).orElse(KubernetesHelper.getDefaultNamespace());
    }

    public Config getConfig() {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.username)) {
            configBuilder.withUsername(this.username);
        }
        if (StringUtils.isNotBlank((CharSequence)this.password)) {
            configBuilder.withPassword(this.password);
        }
        if (StringUtils.isNotBlank((CharSequence)this.masterUrl)) {
            configBuilder.withMasterUrl(this.masterUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.apiVersion)) {
            configBuilder.withApiVersion(this.apiVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)this.caCertData)) {
            configBuilder.withCaCertData(this.caCertData);
        }
        if (StringUtils.isNotBlank((CharSequence)this.caCertFile)) {
            configBuilder.withCaCertFile(this.caCertFile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientCertData)) {
            configBuilder.withClientCertData(this.clientCertData);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientCertFile)) {
            configBuilder.withClientCertFile(this.clientCertFile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientKeyAlgo)) {
            configBuilder.withClientKeyAlgo(this.clientKeyAlgo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientKeyData)) {
            configBuilder.withClientKeyData(this.clientKeyData);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientKeyFile)) {
            configBuilder.withClientKeyFile(this.clientKeyFile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientKeyPassphrase)) {
            configBuilder.withClientKeyPassphrase(this.clientKeyPassphrase);
        }
        if (StringUtils.isNotBlank((CharSequence)this.keyStoreFile)) {
            configBuilder.withKeyStoreFile(this.keyStoreFile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.keyStorePassphrase)) {
            configBuilder.withKeyStorePassphrase(this.keyStorePassphrase);
        }
        if (StringUtils.isNotBlank((CharSequence)this.namespace)) {
            configBuilder.withNamespace(this.getNamespace());
        }
        if (StringUtils.isNotBlank((CharSequence)this.trustStoreFile)) {
            configBuilder.withTrustStoreFile(this.trustStoreFile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.trustStorePassphrase)) {
            configBuilder.withTrustStorePassphrase(this.trustStorePassphrase);
        }
        if (this.trustCerts != null) {
            configBuilder.withTrustCerts(this.trustCerts);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currentContext)) {
            configBuilder.withCurrentContext(((NamedContextBuilder)((NamedContextFluent.ContextNested)((NamedContextBuilder)new NamedContextBuilder().withName(this.currentContext)).withNewContext().withNamespace(this.getNamespace())).endContext()).build());
        }
        return configBuilder.build();
    }

    public static ClusterConfigurationBuilder from(Config kubernetesConfig) {
        return new ClusterConfigurationBuilder().username(kubernetesConfig.getUsername()).password(kubernetesConfig.getPassword()).masterUrl(kubernetesConfig.getMasterUrl()).apiVersion(kubernetesConfig.getApiVersion()).namespace(kubernetesConfig.getNamespace()).caCertFile(kubernetesConfig.getCaCertFile()).caCertData(kubernetesConfig.getCaCertData()).clientCertFile(kubernetesConfig.getClientCertFile()).clientCertData(kubernetesConfig.getClientCertData()).clientKeyFile(kubernetesConfig.getClientKeyFile()).clientKeyData(kubernetesConfig.getClientKeyData()).clientKeyAlgo(kubernetesConfig.getClientKeyAlgo()).clientKeyPassphrase(kubernetesConfig.getClientKeyPassphrase()).currentContext(Optional.ofNullable(kubernetesConfig.getCurrentContext()).map(NamedContext::getName).orElse(null)).trustStoreFile(kubernetesConfig.getTrustStoreFile()).trustStorePassphrase(kubernetesConfig.getTrustStorePassphrase()).keyStoreFile(kubernetesConfig.getKeyStoreFile()).keyStorePassphrase(kubernetesConfig.getKeyStorePassphrase()).trustCerts(kubernetesConfig.isTrustCerts());
    }

    public static ClusterConfigurationBuilder from(Properties ... properties) {
        return ClusterConfiguration.from(new ClusterConfiguration(), properties);
    }

    public static ClusterConfigurationBuilder from(ClusterConfiguration clusterConfiguration, Properties ... properties) {
        ClusterConfiguration c = Optional.ofNullable(clusterConfiguration).orElse(new ClusterConfiguration());
        Properties mergedProperties = Stream.of(properties).collect(Properties::new, Map::putAll, Map::putAll);
        Field[] fields = ClusterConfiguration.class.getDeclaredFields();
        Stream.of(fields).filter(f -> mergedProperties.containsKey(PROPERTY_PREFIX.concat(f.getName()))).forEach(f -> {
            f.setAccessible(true);
            try {
                f.set(c, mergedProperties.get(PROPERTY_PREFIX.concat(f.getName())).toString());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        });
        return c.toBuilder();
    }

    public static ClusterConfigurationBuilder builder() {
        return new ClusterConfigurationBuilder();
    }

    public ClusterConfigurationBuilder toBuilder() {
        return new ClusterConfigurationBuilder().username(this.username).password(this.password).masterUrl(this.masterUrl).apiVersion(this.apiVersion).namespace(this.namespace).caCertFile(this.caCertFile).caCertData(this.caCertData).clientCertFile(this.clientCertFile).clientCertData(this.clientCertData).clientKeyFile(this.clientKeyFile).clientKeyData(this.clientKeyData).clientKeyAlgo(this.clientKeyAlgo).clientKeyPassphrase(this.clientKeyPassphrase).currentContext(this.currentContext).trustStoreFile(this.trustStoreFile).trustStorePassphrase(this.trustStorePassphrase).keyStoreFile(this.keyStoreFile).keyStorePassphrase(this.keyStorePassphrase).trustCerts(this.trustCerts);
    }

    public ClusterConfiguration(String username, String password, String masterUrl, String apiVersion, String namespace, String caCertFile, String caCertData, String clientCertFile, String clientCertData, String clientKeyFile, String clientKeyData, String clientKeyAlgo, String clientKeyPassphrase, String currentContext, String trustStoreFile, String trustStorePassphrase, String keyStoreFile, String keyStorePassphrase, Boolean trustCerts) {
        this.username = username;
        this.password = password;
        this.masterUrl = masterUrl;
        this.apiVersion = apiVersion;
        this.namespace = namespace;
        this.caCertFile = caCertFile;
        this.caCertData = caCertData;
        this.clientCertFile = clientCertFile;
        this.clientCertData = clientCertData;
        this.clientKeyFile = clientKeyFile;
        this.clientKeyData = clientKeyData;
        this.clientKeyAlgo = clientKeyAlgo;
        this.clientKeyPassphrase = clientKeyPassphrase;
        this.currentContext = currentContext;
        this.trustStoreFile = trustStoreFile;
        this.trustStorePassphrase = trustStorePassphrase;
        this.keyStoreFile = keyStoreFile;
        this.keyStorePassphrase = keyStorePassphrase;
        this.trustCerts = trustCerts;
    }

    public ClusterConfiguration() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterConfiguration)) {
            return false;
        }
        ClusterConfiguration other = (ClusterConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$trustCerts = this.trustCerts;
        Boolean other$trustCerts = other.trustCerts;
        if (this$trustCerts == null ? other$trustCerts != null : !((Object)this$trustCerts).equals(other$trustCerts)) {
            return false;
        }
        String this$username = this.username;
        String other$username = other.username;
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.password;
        String other$password = other.password;
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$masterUrl = this.masterUrl;
        String other$masterUrl = other.masterUrl;
        if (this$masterUrl == null ? other$masterUrl != null : !this$masterUrl.equals(other$masterUrl)) {
            return false;
        }
        String this$apiVersion = this.apiVersion;
        String other$apiVersion = other.apiVersion;
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$caCertFile = this.caCertFile;
        String other$caCertFile = other.caCertFile;
        if (this$caCertFile == null ? other$caCertFile != null : !this$caCertFile.equals(other$caCertFile)) {
            return false;
        }
        String this$caCertData = this.caCertData;
        String other$caCertData = other.caCertData;
        if (this$caCertData == null ? other$caCertData != null : !this$caCertData.equals(other$caCertData)) {
            return false;
        }
        String this$clientCertFile = this.clientCertFile;
        String other$clientCertFile = other.clientCertFile;
        if (this$clientCertFile == null ? other$clientCertFile != null : !this$clientCertFile.equals(other$clientCertFile)) {
            return false;
        }
        String this$clientCertData = this.clientCertData;
        String other$clientCertData = other.clientCertData;
        if (this$clientCertData == null ? other$clientCertData != null : !this$clientCertData.equals(other$clientCertData)) {
            return false;
        }
        String this$clientKeyFile = this.clientKeyFile;
        String other$clientKeyFile = other.clientKeyFile;
        if (this$clientKeyFile == null ? other$clientKeyFile != null : !this$clientKeyFile.equals(other$clientKeyFile)) {
            return false;
        }
        String this$clientKeyData = this.clientKeyData;
        String other$clientKeyData = other.clientKeyData;
        if (this$clientKeyData == null ? other$clientKeyData != null : !this$clientKeyData.equals(other$clientKeyData)) {
            return false;
        }
        String this$clientKeyAlgo = this.clientKeyAlgo;
        String other$clientKeyAlgo = other.clientKeyAlgo;
        if (this$clientKeyAlgo == null ? other$clientKeyAlgo != null : !this$clientKeyAlgo.equals(other$clientKeyAlgo)) {
            return false;
        }
        String this$clientKeyPassphrase = this.clientKeyPassphrase;
        String other$clientKeyPassphrase = other.clientKeyPassphrase;
        if (this$clientKeyPassphrase == null ? other$clientKeyPassphrase != null : !this$clientKeyPassphrase.equals(other$clientKeyPassphrase)) {
            return false;
        }
        String this$currentContext = this.currentContext;
        String other$currentContext = other.currentContext;
        if (this$currentContext == null ? other$currentContext != null : !this$currentContext.equals(other$currentContext)) {
            return false;
        }
        String this$trustStoreFile = this.trustStoreFile;
        String other$trustStoreFile = other.trustStoreFile;
        if (this$trustStoreFile == null ? other$trustStoreFile != null : !this$trustStoreFile.equals(other$trustStoreFile)) {
            return false;
        }
        String this$trustStorePassphrase = this.trustStorePassphrase;
        String other$trustStorePassphrase = other.trustStorePassphrase;
        if (this$trustStorePassphrase == null ? other$trustStorePassphrase != null : !this$trustStorePassphrase.equals(other$trustStorePassphrase)) {
            return false;
        }
        String this$keyStoreFile = this.keyStoreFile;
        String other$keyStoreFile = other.keyStoreFile;
        if (this$keyStoreFile == null ? other$keyStoreFile != null : !this$keyStoreFile.equals(other$keyStoreFile)) {
            return false;
        }
        String this$keyStorePassphrase = this.keyStorePassphrase;
        String other$keyStorePassphrase = other.keyStorePassphrase;
        return !(this$keyStorePassphrase == null ? other$keyStorePassphrase != null : !this$keyStorePassphrase.equals(other$keyStorePassphrase));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $trustCerts = this.trustCerts;
        result = result * 59 + ($trustCerts == null ? 43 : ((Object)$trustCerts).hashCode());
        String $username = this.username;
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.password;
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $masterUrl = this.masterUrl;
        result = result * 59 + ($masterUrl == null ? 43 : $masterUrl.hashCode());
        String $apiVersion = this.apiVersion;
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $caCertFile = this.caCertFile;
        result = result * 59 + ($caCertFile == null ? 43 : $caCertFile.hashCode());
        String $caCertData = this.caCertData;
        result = result * 59 + ($caCertData == null ? 43 : $caCertData.hashCode());
        String $clientCertFile = this.clientCertFile;
        result = result * 59 + ($clientCertFile == null ? 43 : $clientCertFile.hashCode());
        String $clientCertData = this.clientCertData;
        result = result * 59 + ($clientCertData == null ? 43 : $clientCertData.hashCode());
        String $clientKeyFile = this.clientKeyFile;
        result = result * 59 + ($clientKeyFile == null ? 43 : $clientKeyFile.hashCode());
        String $clientKeyData = this.clientKeyData;
        result = result * 59 + ($clientKeyData == null ? 43 : $clientKeyData.hashCode());
        String $clientKeyAlgo = this.clientKeyAlgo;
        result = result * 59 + ($clientKeyAlgo == null ? 43 : $clientKeyAlgo.hashCode());
        String $clientKeyPassphrase = this.clientKeyPassphrase;
        result = result * 59 + ($clientKeyPassphrase == null ? 43 : $clientKeyPassphrase.hashCode());
        String $currentContext = this.currentContext;
        result = result * 59 + ($currentContext == null ? 43 : $currentContext.hashCode());
        String $trustStoreFile = this.trustStoreFile;
        result = result * 59 + ($trustStoreFile == null ? 43 : $trustStoreFile.hashCode());
        String $trustStorePassphrase = this.trustStorePassphrase;
        result = result * 59 + ($trustStorePassphrase == null ? 43 : $trustStorePassphrase.hashCode());
        String $keyStoreFile = this.keyStoreFile;
        result = result * 59 + ($keyStoreFile == null ? 43 : $keyStoreFile.hashCode());
        String $keyStorePassphrase = this.keyStorePassphrase;
        result = result * 59 + ($keyStorePassphrase == null ? 43 : $keyStorePassphrase.hashCode());
        return result;
    }

    public static class ClusterConfigurationBuilder {
        private String username;
        private String password;
        private String masterUrl;
        private String apiVersion;
        private String namespace;
        private String caCertFile;
        private String caCertData;
        private String clientCertFile;
        private String clientCertData;
        private String clientKeyFile;
        private String clientKeyData;
        private String clientKeyAlgo;
        private String clientKeyPassphrase;
        private String currentContext;
        private String trustStoreFile;
        private String trustStorePassphrase;
        private String keyStoreFile;
        private String keyStorePassphrase;
        private Boolean trustCerts;

        ClusterConfigurationBuilder() {
        }

        public ClusterConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ClusterConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ClusterConfigurationBuilder masterUrl(String masterUrl) {
            this.masterUrl = masterUrl;
            return this;
        }

        public ClusterConfigurationBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public ClusterConfigurationBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ClusterConfigurationBuilder caCertFile(String caCertFile) {
            this.caCertFile = caCertFile;
            return this;
        }

        public ClusterConfigurationBuilder caCertData(String caCertData) {
            this.caCertData = caCertData;
            return this;
        }

        public ClusterConfigurationBuilder clientCertFile(String clientCertFile) {
            this.clientCertFile = clientCertFile;
            return this;
        }

        public ClusterConfigurationBuilder clientCertData(String clientCertData) {
            this.clientCertData = clientCertData;
            return this;
        }

        public ClusterConfigurationBuilder clientKeyFile(String clientKeyFile) {
            this.clientKeyFile = clientKeyFile;
            return this;
        }

        public ClusterConfigurationBuilder clientKeyData(String clientKeyData) {
            this.clientKeyData = clientKeyData;
            return this;
        }

        public ClusterConfigurationBuilder clientKeyAlgo(String clientKeyAlgo) {
            this.clientKeyAlgo = clientKeyAlgo;
            return this;
        }

        public ClusterConfigurationBuilder clientKeyPassphrase(String clientKeyPassphrase) {
            this.clientKeyPassphrase = clientKeyPassphrase;
            return this;
        }

        public ClusterConfigurationBuilder currentContext(String currentContext) {
            this.currentContext = currentContext;
            return this;
        }

        public ClusterConfigurationBuilder trustStoreFile(String trustStoreFile) {
            this.trustStoreFile = trustStoreFile;
            return this;
        }

        public ClusterConfigurationBuilder trustStorePassphrase(String trustStorePassphrase) {
            this.trustStorePassphrase = trustStorePassphrase;
            return this;
        }

        public ClusterConfigurationBuilder keyStoreFile(String keyStoreFile) {
            this.keyStoreFile = keyStoreFile;
            return this;
        }

        public ClusterConfigurationBuilder keyStorePassphrase(String keyStorePassphrase) {
            this.keyStorePassphrase = keyStorePassphrase;
            return this;
        }

        public ClusterConfigurationBuilder trustCerts(Boolean trustCerts) {
            this.trustCerts = trustCerts;
            return this;
        }

        public ClusterConfiguration build() {
            return new ClusterConfiguration(this.username, this.password, this.masterUrl, this.apiVersion, this.namespace, this.caCertFile, this.caCertData, this.clientCertFile, this.clientCertData, this.clientKeyFile, this.clientKeyData, this.clientKeyAlgo, this.clientKeyPassphrase, this.currentContext, this.trustStoreFile, this.trustStorePassphrase, this.keyStoreFile, this.keyStorePassphrase, this.trustCerts);
        }

        public String toString() {
            return "ClusterConfiguration.ClusterConfigurationBuilder(username=" + this.username + ", password=" + this.password + ", masterUrl=" + this.masterUrl + ", apiVersion=" + this.apiVersion + ", namespace=" + this.namespace + ", caCertFile=" + this.caCertFile + ", caCertData=" + this.caCertData + ", clientCertFile=" + this.clientCertFile + ", clientCertData=" + this.clientCertData + ", clientKeyFile=" + this.clientKeyFile + ", clientKeyData=" + this.clientKeyData + ", clientKeyAlgo=" + this.clientKeyAlgo + ", clientKeyPassphrase=" + this.clientKeyPassphrase + ", currentContext=" + this.currentContext + ", trustStoreFile=" + this.trustStoreFile + ", trustStorePassphrase=" + this.trustStorePassphrase + ", keyStoreFile=" + this.keyStoreFile + ", keyStorePassphrase=" + this.keyStorePassphrase + ", trustCerts=" + this.trustCerts + ")";
        }
    }
}

