/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.archive;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.eclipse.jkube.kit.common.archive.ArchiveCompression;
import org.eclipse.jkube.kit.common.util.FileUtil;

public class JKubeTarArchiver {
    private JKubeTarArchiver() {
    }

    public static File createTarBallOfDirectory(File outputFile, File inputDirectory, ArchiveCompression compression) throws IOException {
        return JKubeTarArchiver.createTarBall(outputFile, inputDirectory, FileUtil.listFilesAndDirsRecursivelyInDirectory(inputDirectory), Collections.emptyMap(), compression);
    }

    public static File createTarBall(File outputFile, File inputDirectory, List<File> fileList, Map<File, String> fileModeMap, ArchiveCompression compression) throws IOException {
        return JKubeTarArchiver.createTarBall(outputFile, inputDirectory, fileList, fileModeMap, compression, null, null);
    }

    public static File createTarBall(File outputFile, File inputDirectory, List<File> fileList, Map<File, String> fileModeMap, ArchiveCompression compression, Consumer<TarArchiveOutputStream> tarCustomizer, Consumer<TarArchiveEntry> tarArchiveEntryCustomizer) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            TarArchiveOutputStream tarArchiveOutputStream = compression.equals((Object)ArchiveCompression.gzip) ? new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)bufferedOutputStream)) : (compression.equals((Object)ArchiveCompression.bzip2) ? new TarArchiveOutputStream((OutputStream)new BZip2CompressorOutputStream((OutputStream)bufferedOutputStream)) : new TarArchiveOutputStream((OutputStream)bufferedOutputStream));
            tarArchiveOutputStream.setBigNumberMode(2);
            tarArchiveOutputStream.setLongFileMode(3);
            Optional.ofNullable(tarCustomizer).ifPresent(tc -> tc.accept(tarArchiveOutputStream));
            for (File currentFile : fileList) {
                String relativeFilePath = inputDirectory.toURI().relativize(new File(currentFile.getAbsolutePath()).toURI()).getPath();
                TarArchiveEntry tarEntry = new TarArchiveEntry(currentFile, relativeFilePath);
                tarEntry.setSize(currentFile.length());
                if (fileModeMap.containsKey(currentFile)) {
                    tarEntry.setMode(Integer.parseInt(fileModeMap.get(currentFile), 8));
                } else if (currentFile.isDirectory()) {
                    tarEntry.setMode(16877);
                }
                if (currentFile.isDirectory()) {
                    tarEntry.setSize(0L);
                }
                Optional.ofNullable(tarArchiveEntryCustomizer).ifPresent(tac -> tac.accept(tarEntry));
                tarArchiveOutputStream.putArchiveEntry(tarEntry);
                if (currentFile.isFile()) {
                    try (FileInputStream fis = new FileInputStream(currentFile);){
                        IOUtils.copy((InputStream)fis, (OutputStream)tarArchiveOutputStream);
                    }
                }
                tarArchiveOutputStream.closeArchiveEntry();
            }
            tarArchiveOutputStream.close();
        }
        return outputFile;
    }
}

