/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.archive;

import java.io.File;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFile;

public class AssemblyFileUtils {
    private AssemblyFileUtils() {
    }

    public static File getAssemblyFileOutputDirectory(AssemblyFile assemblyFile, File outputDirectoryForRelativePaths, Assembly layer, AssemblyConfiguration assemblyConfiguration) {
        File outputDirectory;
        Objects.requireNonNull(assemblyFile.getOutputDirectory(), "Assembly Configuration output dir is required");
        if (assemblyFile.getOutputDirectory().isAbsolute()) {
            outputDirectory = assemblyFile.getOutputDirectory();
        } else if (StringUtils.isBlank((CharSequence)layer.getId())) {
            Objects.requireNonNull(assemblyConfiguration.getTargetDir(), "Assembly Configuration target dir is required");
            outputDirectory = new File(outputDirectoryForRelativePaths, assemblyConfiguration.getTargetDir()).toPath().resolve(assemblyFile.getOutputDirectory().toPath()).toFile();
        } else {
            Objects.requireNonNull(assemblyConfiguration.getTargetDir(), "Assembly Configuration target dir is required");
            outputDirectory = new File(new File(outputDirectoryForRelativePaths, layer.getId()), assemblyConfiguration.getTargetDir()).toPath().resolve(assemblyFile.getOutputDirectory().toPath()).toFile();
        }
        return outputDirectory;
    }

    public static File resolveSourceFile(File baseDirectory, AssemblyFile assemblyFile) {
        return baseDirectory.toPath().resolve(Objects.requireNonNull(assemblyFile.getSource(), "Assembly File source is required").toPath()).toFile();
    }
}

