/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.EnvUtil;

public class ProcessUtil {
    private ProcessUtil() {
    }

    public static int runCommand(KitLogger log, File command, List<String> args) throws IOException {
        return ProcessUtil.runCommand(log, command, args, false);
    }

    public static int runCommand(KitLogger log, File command, List<String> args, boolean withShutdownHook) throws IOException {
        return ProcessUtil.runAsyncCommand(log, command, args, withShutdownHook, true).await();
    }

    public static ProcessExecutionContext runAsyncCommand(KitLogger log, File command, List<String> args, boolean withShutdownHook, boolean useStandardLoggingLevel) throws IOException {
        String[] commandWithArgs = ProcessUtil.prepareCommandArray(command.getAbsolutePath(), args);
        Process process = Runtime.getRuntime().exec(commandWithArgs);
        if (withShutdownHook) {
            ProcessUtil.addShutdownHook(log, process, command);
        }
        List<Thread> threads = ProcessUtil.startLoggingThreads(process, log, command.getName() + " " + StringUtils.join(args, (String)" "), useStandardLoggingLevel);
        return new ProcessExecutionContext(process, threads, log);
    }

    private static void joinThreads(List<Thread> threads, KitLogger log) {
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                log.warn("Caught %s", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static File findExecutable(KitLogger log, String name) {
        return ProcessUtil.findExecutable(log, name, ProcessUtil.getPathDirectories());
    }

    public static File findExecutable(KitLogger log, String name, List<File> directories) {
        for (File directory : directories) {
            String[] stringArray;
            if (EnvUtil.isWindows()) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = ".exe";
                stringArray2[1] = ".bat";
                stringArray2[2] = ".cmd";
                stringArray = stringArray2;
                stringArray2[3] = "";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "";
            }
            for (String extension : stringArray) {
                File file = new File(directory, name + extension);
                if (!file.exists() || !file.isFile()) continue;
                if (!file.canExecute()) {
                    log.warn("Found %s on the PATH but it is not executable. Ignoring ...", file);
                    continue;
                }
                return file;
            }
        }
        return null;
    }

    public static boolean folderIsOnPath(KitLogger logger, File dir) {
        List<File> paths = ProcessUtil.getPathDirectories();
        if (paths.isEmpty()) {
            logger.warn("The $PATH environment variable is empty! Usually you have a PATH defined to find binaries.", new Object[0]);
            logger.warn("Please report this to the jkube team: https://github.com/fabric8org.eclipse.jkube-maven-plugin/issues/new", new Object[0]);
            return false;
        }
        for (File path : paths) {
            if (!ProcessUtil.canonicalPath(path).equals(ProcessUtil.canonicalPath(dir))) continue;
            return true;
        }
        return false;
    }

    private static void addShutdownHook(final KitLogger log, final Process process, final File command) {
        Runtime.getRuntime().addShutdownHook(new Thread(command.getName()){

            @Override
            public void run() {
                if (process != null) {
                    boolean alive = false;
                    try {
                        process.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        alive = true;
                    }
                    if (alive) {
                        log.info("Terminating process %s", command);
                        try {
                            process.destroy();
                        }
                        catch (Exception e) {
                            log.error("Failed to terminate process %s", command);
                        }
                    }
                }
            }
        });
    }

    private static String[] prepareCommandArray(String command, List<String> args) {
        ArrayList nArgs = args != null ? args : new ArrayList();
        String[] commandWithArgs = new String[nArgs.size() + 1];
        commandWithArgs[0] = command;
        for (int i = 0; i < nArgs.size(); ++i) {
            commandWithArgs[i + 1] = (String)nArgs.get(i);
        }
        return commandWithArgs;
    }

    private static void processOutput(InputStream inputStream, Function<String, Void> function) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                function.apply(line);
            }
        }
    }

    private static String canonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    private static List<File> getPathDirectories() {
        ArrayList<File> pathDirectories = new ArrayList<File>();
        String pathText = System.getenv("PATH");
        if (EnvUtil.isWindows() && pathText == null) {
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                if (!entry.getKey().equalsIgnoreCase("PATH")) continue;
                pathText = entry.getValue();
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)pathText)) {
            String[] pathTexts;
            for (String text : pathTexts = pathText.split(File.pathSeparator)) {
                File dir = new File(text);
                if (!dir.exists() || !dir.isDirectory()) continue;
                pathDirectories.add(dir);
            }
        }
        return pathDirectories;
    }

    private static List<Thread> startLoggingThreads(Process process, KitLogger log, String commandDesc, boolean useStandardLoggingLevel) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        threads.add(ProcessUtil.startOutputLoggingThread(process, log, commandDesc, useStandardLoggingLevel));
        threads.add(ProcessUtil.startErrorLoggingThread(process, log, commandDesc, useStandardLoggingLevel));
        return threads;
    }

    private static Thread startErrorLoggingThread(final Process process, final KitLogger log, final String commandDesc, final boolean useStandardLoggingLevel) {
        Thread logThread = new Thread("[ERR] " + commandDesc){

            @Override
            public void run() {
                try {
                    ProcessUtil.processOutput(process.getErrorStream(), ProcessUtil.createErrorHandler(log, useStandardLoggingLevel));
                }
                catch (IOException e) {
                    log.error("Failed to read error stream from %s : %s", commandDesc, e.getMessage());
                }
            }
        };
        logThread.setDaemon(true);
        logThread.start();
        return logThread;
    }

    private static Thread startOutputLoggingThread(final Process process, final KitLogger log, final String commandDesc, final boolean useStandardLoggingLevel) {
        Thread logThread = new Thread("[OUT] " + commandDesc){

            @Override
            public void run() {
                try {
                    ProcessUtil.processOutput(process.getInputStream(), ProcessUtil.createOutputHandler(log, useStandardLoggingLevel));
                }
                catch (IOException e) {
                    log.error("Failed to read output stream from %s : %s", commandDesc, e.getMessage());
                }
            }
        };
        logThread.setDaemon(true);
        logThread.start();
        return logThread;
    }

    private static Function<String, Void> createOutputHandler(KitLogger log, boolean useStandardLoggingLevel) {
        return outputLine -> {
            if (useStandardLoggingLevel) {
                log.info("%s", outputLine);
            } else {
                log.debug("%s", outputLine);
            }
            return null;
        };
    }

    private static Function<String, Void> createErrorHandler(KitLogger log, boolean useStandardLoggingLevel) {
        return outputLine -> {
            if (useStandardLoggingLevel) {
                log.error("%s", outputLine);
            } else {
                log.warn("%s", outputLine);
            }
            return null;
        };
    }

    public static class ProcessExecutionContext
    implements Closeable {
        private Process process;
        private List<Thread> loggingThreads;
        private KitLogger log;

        public ProcessExecutionContext(Process process, List<Thread> loggingThreads, KitLogger log) {
            this.process = process;
            this.loggingThreads = loggingThreads;
            this.log = log;
        }

        public int await() {
            try {
                int answer = this.process.waitFor();
                ProcessUtil.joinThreads(this.loggingThreads, this.log);
                return answer;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return this.process.exitValue();
            }
        }

        @Override
        public void close() {
            this.process.destroy();
            this.await();
        }
    }
}

