/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonObject;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.Template;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.GenericCustomResource;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static boolean jsonEquals(JsonObject first, JsonObject second) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode tree1 = mapper.readTree(first.toString());
            JsonNode tree2 = mapper.readTree(second.toString());
            return tree1.equals((Object)tree2);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static List<HasMetadata> deserializeKubernetesListOrTemplate(File manifest) throws IOException {
        String fileContentAsStr;
        ArrayList<HasMetadata> kubernetesResources = new ArrayList<HasMetadata>();
        if (manifest.isFile() && StringUtils.isNotBlank((CharSequence)(fileContentAsStr = new String(Files.readAllBytes(manifest.toPath()), StandardCharsets.UTF_8)))) {
            kubernetesResources.addAll(ResourceUtil.parseKubernetesListOrTemplate(ResourceFileType.fromFile(manifest).getObjectMapper(), fileContentAsStr));
        }
        return kubernetesResources;
    }

    private static List<HasMetadata> parseKubernetesListOrTemplate(ObjectMapper mapper, String manifestString) throws IOException {
        Map manifest = (Map)mapper.readValue(manifestString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (manifest.get("kind").equals(new Template().getKind())) {
            return Optional.ofNullable(OpenshiftHelper.processTemplatesLocally((Template)mapper.convertValue((Object)manifest, Template.class), false)).map(KubernetesList::getItems).orElse(Collections.emptyList());
        }
        return ResourceUtil.parseKubernetesList(mapper, manifest);
    }

    private static List<HasMetadata> parseKubernetesList(ObjectMapper mapper, Map<String, Object> manifest) {
        List items = (List)manifest.get("items");
        return items.stream().map(item -> {
            GenericCustomResource fallback = (GenericCustomResource)mapper.convertValue(item, GenericCustomResource.class);
            try {
                return (HasMetadata)mapper.convertValue((Object)fallback, HasMetadata.class);
            }
            catch (Exception ex) {
                return fallback;
            }
        }).collect(Collectors.toList());
    }

    public static <T extends KubernetesResource> T load(File file, Class<T> clazz) throws IOException {
        ResourceFileType type = ResourceFileType.fromFile(file);
        return ResourceUtil.load(file, clazz, type);
    }

    private static boolean isGenericCustomResourceCompatible(Class<?> clazz) {
        return clazz.isAssignableFrom(GenericCustomResource.class);
    }

    public static <T extends KubernetesResource> T load(File file, Class<T> clazz, ResourceFileType resourceFileType) throws IOException {
        try {
            return (T)((KubernetesResource)ResourceUtil.getObjectMapper(resourceFileType).readValue(file, clazz));
        }
        catch (IOException ex) {
            if (ResourceUtil.isGenericCustomResourceCompatible(clazz)) {
                return (T)((KubernetesResource)clazz.cast(ResourceUtil.getObjectMapper(resourceFileType).readValue(file, GenericCustomResource.class)));
            }
            throw ex;
        }
    }

    public static <T extends KubernetesResource> T load(InputStream in, Class<T> clazz, ResourceFileType resourceFileType) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)baos);
            return (T)((KubernetesResource)ResourceUtil.getObjectMapper(resourceFileType).readValue(baos.toByteArray(), clazz));
        }
        catch (IOException ex) {
            if (ResourceUtil.isGenericCustomResourceCompatible(clazz)) {
                return (T)((KubernetesResource)clazz.cast(ResourceUtil.getObjectMapper(resourceFileType).readValue(baos.toByteArray(), GenericCustomResource.class)));
            }
            throw ex;
        }
    }

    public static File save(File file, Object data) throws IOException {
        return ResourceUtil.save(file, data, ResourceFileType.fromFile(file));
    }

    public static File save(File file, Object data, ResourceFileType type) throws IOException {
        boolean hasExtension = FilenameUtils.indexOfExtension((String)file.getAbsolutePath()) != -1;
        File output = hasExtension ? file : type.addExtensionIfMissing(file);
        ResourceUtil.ensureDir(file);
        ResourceUtil.getObjectMapper(type).writeValue(output, data);
        return output;
    }

    public static String toYaml(Object resource) throws JsonProcessingException {
        return ResourceUtil.serializeAsString(resource, ResourceFileType.yaml);
    }

    public static String toJson(Object resource) throws JsonProcessingException {
        return ResourceUtil.serializeAsString(resource, ResourceFileType.json);
    }

    private static String serializeAsString(Object resource, ResourceFileType resourceFileType) throws JsonProcessingException {
        return ResourceUtil.getObjectMapper(resourceFileType).writeValueAsString(resource);
    }

    private static ObjectMapper getObjectMapper(ResourceFileType resourceFileType) {
        return resourceFileType.getObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS).disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
    }

    private static void ensureDir(File file) throws IOException {
        File parentDir = file.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Cannot create directory " + parentDir);
        }
    }

    public static File getFinalResourceDir(File resourceDir, String environment) {
        if (resourceDir != null && StringUtils.isNotEmpty((CharSequence)environment)) {
            return new File(resourceDir, environment);
        }
        return resourceDir;
    }
}

