/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.image;

import java.io.Serializable;
import java.util.Optional;
import org.eclipse.jkube.kit.config.image.WatchMode;

public class WatchImageConfiguration
implements Serializable {
    private static final long serialVersionUID = -8837447095092135706L;
    private Integer interval;
    private WatchMode mode;
    private String postGoal;
    private String postExec;

    public int getInterval() {
        return this.interval != null ? this.interval : 5000;
    }

    public Integer getIntervalRaw() {
        return this.interval;
    }

    public static WatchImageConfigurationBuilder builder() {
        return new WatchImageConfigurationBuilder();
    }

    public WatchImageConfigurationBuilder toBuilder() {
        return new WatchImageConfigurationBuilder().interval(this.interval).mode(this.mode).postGoal(this.postGoal).postExec(this.postExec);
    }

    public WatchImageConfiguration(Integer interval, WatchMode mode, String postGoal, String postExec) {
        this.interval = interval;
        this.mode = mode;
        this.postGoal = postGoal;
        this.postExec = postExec;
    }

    public WatchImageConfiguration() {
    }

    public WatchMode getMode() {
        return this.mode;
    }

    public String getPostGoal() {
        return this.postGoal;
    }

    public String getPostExec() {
        return this.postExec;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WatchImageConfiguration)) {
            return false;
        }
        WatchImageConfiguration other = (WatchImageConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInterval() != other.getInterval()) {
            return false;
        }
        WatchMode this$mode = this.getMode();
        WatchMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        String this$postGoal = this.getPostGoal();
        String other$postGoal = other.getPostGoal();
        if (this$postGoal == null ? other$postGoal != null : !this$postGoal.equals(other$postGoal)) {
            return false;
        }
        String this$postExec = this.getPostExec();
        String other$postExec = other.getPostExec();
        return !(this$postExec == null ? other$postExec != null : !this$postExec.equals(other$postExec));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WatchImageConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInterval();
        WatchMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        String $postGoal = this.getPostGoal();
        result = result * 59 + ($postGoal == null ? 43 : $postGoal.hashCode());
        String $postExec = this.getPostExec();
        result = result * 59 + ($postExec == null ? 43 : $postExec.hashCode());
        return result;
    }

    public static class WatchImageConfigurationBuilder {
        private Integer interval;
        private WatchMode mode;
        private String postGoal;
        private String postExec;

        public WatchImageConfigurationBuilder modeString(String modeString) {
            this.mode = Optional.ofNullable(modeString).map(String::toLowerCase).map(WatchMode::valueOf).orElse(null);
            return this;
        }

        WatchImageConfigurationBuilder() {
        }

        public WatchImageConfigurationBuilder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public WatchImageConfigurationBuilder mode(WatchMode mode) {
            this.mode = mode;
            return this;
        }

        public WatchImageConfigurationBuilder postGoal(String postGoal) {
            this.postGoal = postGoal;
            return this;
        }

        public WatchImageConfigurationBuilder postExec(String postExec) {
            this.postExec = postExec;
            return this;
        }

        public WatchImageConfiguration build() {
            return new WatchImageConfiguration(this.interval, this.mode, this.postGoal, this.postExec);
        }

        public String toString() {
            return "WatchImageConfiguration.WatchImageConfigurationBuilder(interval=" + this.interval + ", mode=" + (Object)((Object)this.mode) + ", postGoal=" + this.postGoal + ", postExec=" + this.postExec + ")";
        }
    }
}

