/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.resource;

import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jkube.kit.config.resource.ConfigMap;
import org.eclipse.jkube.kit.config.resource.MetaDataConfig;
import org.eclipse.jkube.kit.config.resource.MetricsConfig;
import org.eclipse.jkube.kit.config.resource.OpenshiftBuildConfig;
import org.eclipse.jkube.kit.config.resource.ProbeConfig;
import org.eclipse.jkube.kit.config.resource.SecretConfig;
import org.eclipse.jkube.kit.config.resource.ServiceAccountConfig;
import org.eclipse.jkube.kit.config.resource.ServiceConfig;
import org.eclipse.jkube.kit.config.resource.VolumeConfig;

public class ResourceConfig {
    private Map<String, String> env;
    private MetaDataConfig labels;
    private MetaDataConfig annotations;
    private List<VolumeConfig> volumes;
    private List<SecretConfig> secrets;
    private String controllerName;
    private List<ServiceConfig> services;
    private List<String> remotes;
    private ConfigMap configMap;
    private ProbeConfig liveness;
    private ProbeConfig readiness;
    private MetricsConfig metrics;
    private boolean containerPrivileged;
    private String imagePullPolicy;
    private Map<String, Integer> ports;
    private int replicas = 1;
    private String namespace;
    private String serviceAccount;
    private List<String> customResourceDefinitions;
    private List<ServiceAccountConfig> serviceAccounts;
    private List<IngressRule> ingressRules;
    private OpenshiftBuildConfig openshiftBuildConfig;
    private String routeDomain;

    public static ResourceConfigBuilder toBuilder(ResourceConfig original) {
        return Optional.ofNullable(original).orElse(new ResourceConfig()).toBuilder();
    }

    public static ResourceConfigBuilder builder() {
        return new ResourceConfigBuilder();
    }

    public ResourceConfigBuilder toBuilder() {
        ResourceConfigBuilder builder = new ResourceConfigBuilder().env(this.env).labels(this.labels).annotations(this.annotations).controllerName(this.controllerName).configMap(this.configMap).liveness(this.liveness).readiness(this.readiness).metrics(this.metrics).containerPrivileged(this.containerPrivileged).imagePullPolicy(this.imagePullPolicy).replicas(this.replicas).namespace(this.namespace).serviceAccount(this.serviceAccount).openshiftBuildConfig(this.openshiftBuildConfig).routeDomain(this.routeDomain);
        if (this.volumes != null) {
            builder.volumes(this.volumes);
        }
        if (this.secrets != null) {
            builder.secrets(this.secrets);
        }
        if (this.services != null) {
            builder.services(this.services);
        }
        if (this.remotes != null) {
            builder.remotes(this.remotes);
        }
        if (this.ports != null) {
            builder.ports(this.ports);
        }
        if (this.customResourceDefinitions != null) {
            builder.customResourceDefinitions(this.customResourceDefinitions);
        }
        if (this.serviceAccounts != null) {
            builder.serviceAccounts(this.serviceAccounts);
        }
        if (this.ingressRules != null) {
            builder.ingressRules(this.ingressRules);
        }
        return builder;
    }

    public ResourceConfig(Map<String, String> env, MetaDataConfig labels, MetaDataConfig annotations, List<VolumeConfig> volumes, List<SecretConfig> secrets, String controllerName, List<ServiceConfig> services, List<String> remotes, ConfigMap configMap, ProbeConfig liveness, ProbeConfig readiness, MetricsConfig metrics, boolean containerPrivileged, String imagePullPolicy, Map<String, Integer> ports, int replicas, String namespace, String serviceAccount, List<String> customResourceDefinitions, List<ServiceAccountConfig> serviceAccounts, List<IngressRule> ingressRules, OpenshiftBuildConfig openshiftBuildConfig, String routeDomain) {
        this.env = env;
        this.labels = labels;
        this.annotations = annotations;
        this.volumes = volumes;
        this.secrets = secrets;
        this.controllerName = controllerName;
        this.services = services;
        this.remotes = remotes;
        this.configMap = configMap;
        this.liveness = liveness;
        this.readiness = readiness;
        this.metrics = metrics;
        this.containerPrivileged = containerPrivileged;
        this.imagePullPolicy = imagePullPolicy;
        this.ports = ports;
        this.replicas = replicas;
        this.namespace = namespace;
        this.serviceAccount = serviceAccount;
        this.customResourceDefinitions = customResourceDefinitions;
        this.serviceAccounts = serviceAccounts;
        this.ingressRules = ingressRules;
        this.openshiftBuildConfig = openshiftBuildConfig;
        this.routeDomain = routeDomain;
    }

    public ResourceConfig() {
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public MetaDataConfig getLabels() {
        return this.labels;
    }

    public MetaDataConfig getAnnotations() {
        return this.annotations;
    }

    public List<VolumeConfig> getVolumes() {
        return this.volumes;
    }

    public List<SecretConfig> getSecrets() {
        return this.secrets;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public List<ServiceConfig> getServices() {
        return this.services;
    }

    public List<String> getRemotes() {
        return this.remotes;
    }

    public ConfigMap getConfigMap() {
        return this.configMap;
    }

    public ProbeConfig getLiveness() {
        return this.liveness;
    }

    public ProbeConfig getReadiness() {
        return this.readiness;
    }

    public MetricsConfig getMetrics() {
        return this.metrics;
    }

    public boolean isContainerPrivileged() {
        return this.containerPrivileged;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public Map<String, Integer> getPorts() {
        return this.ports;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public List<String> getCustomResourceDefinitions() {
        return this.customResourceDefinitions;
    }

    public List<ServiceAccountConfig> getServiceAccounts() {
        return this.serviceAccounts;
    }

    public List<IngressRule> getIngressRules() {
        return this.ingressRules;
    }

    public OpenshiftBuildConfig getOpenshiftBuildConfig() {
        return this.openshiftBuildConfig;
    }

    public String getRouteDomain() {
        return this.routeDomain;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceConfig)) {
            return false;
        }
        ResourceConfig other = (ResourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        MetaDataConfig this$labels = this.getLabels();
        MetaDataConfig other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        MetaDataConfig this$annotations = this.getAnnotations();
        MetaDataConfig other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        List<VolumeConfig> this$volumes = this.getVolumes();
        List<VolumeConfig> other$volumes = other.getVolumes();
        if (this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes)) {
            return false;
        }
        List<SecretConfig> this$secrets = this.getSecrets();
        List<SecretConfig> other$secrets = other.getSecrets();
        if (this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets)) {
            return false;
        }
        String this$controllerName = this.getControllerName();
        String other$controllerName = other.getControllerName();
        if (this$controllerName == null ? other$controllerName != null : !this$controllerName.equals(other$controllerName)) {
            return false;
        }
        List<ServiceConfig> this$services = this.getServices();
        List<ServiceConfig> other$services = other.getServices();
        if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
            return false;
        }
        List<String> this$remotes = this.getRemotes();
        List<String> other$remotes = other.getRemotes();
        if (this$remotes == null ? other$remotes != null : !((Object)this$remotes).equals(other$remotes)) {
            return false;
        }
        ConfigMap this$configMap = this.getConfigMap();
        ConfigMap other$configMap = other.getConfigMap();
        if (this$configMap == null ? other$configMap != null : !this$configMap.equals(other$configMap)) {
            return false;
        }
        ProbeConfig this$liveness = this.getLiveness();
        ProbeConfig other$liveness = other.getLiveness();
        if (this$liveness == null ? other$liveness != null : !((Object)this$liveness).equals(other$liveness)) {
            return false;
        }
        ProbeConfig this$readiness = this.getReadiness();
        ProbeConfig other$readiness = other.getReadiness();
        if (this$readiness == null ? other$readiness != null : !((Object)this$readiness).equals(other$readiness)) {
            return false;
        }
        MetricsConfig this$metrics = this.getMetrics();
        MetricsConfig other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
            return false;
        }
        if (this.isContainerPrivileged() != other.isContainerPrivileged()) {
            return false;
        }
        String this$imagePullPolicy = this.getImagePullPolicy();
        String other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy)) {
            return false;
        }
        Map<String, Integer> this$ports = this.getPorts();
        Map<String, Integer> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        if (this.getReplicas() != other.getReplicas()) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$serviceAccount = this.getServiceAccount();
        String other$serviceAccount = other.getServiceAccount();
        if (this$serviceAccount == null ? other$serviceAccount != null : !this$serviceAccount.equals(other$serviceAccount)) {
            return false;
        }
        List<String> this$customResourceDefinitions = this.getCustomResourceDefinitions();
        List<String> other$customResourceDefinitions = other.getCustomResourceDefinitions();
        if (this$customResourceDefinitions == null ? other$customResourceDefinitions != null : !((Object)this$customResourceDefinitions).equals(other$customResourceDefinitions)) {
            return false;
        }
        List<ServiceAccountConfig> this$serviceAccounts = this.getServiceAccounts();
        List<ServiceAccountConfig> other$serviceAccounts = other.getServiceAccounts();
        if (this$serviceAccounts == null ? other$serviceAccounts != null : !((Object)this$serviceAccounts).equals(other$serviceAccounts)) {
            return false;
        }
        List<IngressRule> this$ingressRules = this.getIngressRules();
        List<IngressRule> other$ingressRules = other.getIngressRules();
        if (this$ingressRules == null ? other$ingressRules != null : !((Object)this$ingressRules).equals(other$ingressRules)) {
            return false;
        }
        OpenshiftBuildConfig this$openshiftBuildConfig = this.getOpenshiftBuildConfig();
        OpenshiftBuildConfig other$openshiftBuildConfig = other.getOpenshiftBuildConfig();
        if (this$openshiftBuildConfig == null ? other$openshiftBuildConfig != null : !((Object)this$openshiftBuildConfig).equals(other$openshiftBuildConfig)) {
            return false;
        }
        String this$routeDomain = this.getRouteDomain();
        String other$routeDomain = other.getRouteDomain();
        return !(this$routeDomain == null ? other$routeDomain != null : !this$routeDomain.equals(other$routeDomain));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        MetaDataConfig $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        MetaDataConfig $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        List<VolumeConfig> $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        List<SecretConfig> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        String $controllerName = this.getControllerName();
        result = result * 59 + ($controllerName == null ? 43 : $controllerName.hashCode());
        List<ServiceConfig> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        List<String> $remotes = this.getRemotes();
        result = result * 59 + ($remotes == null ? 43 : ((Object)$remotes).hashCode());
        ConfigMap $configMap = this.getConfigMap();
        result = result * 59 + ($configMap == null ? 43 : $configMap.hashCode());
        ProbeConfig $liveness = this.getLiveness();
        result = result * 59 + ($liveness == null ? 43 : ((Object)$liveness).hashCode());
        ProbeConfig $readiness = this.getReadiness();
        result = result * 59 + ($readiness == null ? 43 : ((Object)$readiness).hashCode());
        MetricsConfig $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        result = result * 59 + (this.isContainerPrivileged() ? 79 : 97);
        String $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        Map<String, Integer> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        result = result * 59 + this.getReplicas();
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $serviceAccount = this.getServiceAccount();
        result = result * 59 + ($serviceAccount == null ? 43 : $serviceAccount.hashCode());
        List<String> $customResourceDefinitions = this.getCustomResourceDefinitions();
        result = result * 59 + ($customResourceDefinitions == null ? 43 : ((Object)$customResourceDefinitions).hashCode());
        List<ServiceAccountConfig> $serviceAccounts = this.getServiceAccounts();
        result = result * 59 + ($serviceAccounts == null ? 43 : ((Object)$serviceAccounts).hashCode());
        List<IngressRule> $ingressRules = this.getIngressRules();
        result = result * 59 + ($ingressRules == null ? 43 : ((Object)$ingressRules).hashCode());
        OpenshiftBuildConfig $openshiftBuildConfig = this.getOpenshiftBuildConfig();
        result = result * 59 + ($openshiftBuildConfig == null ? 43 : ((Object)$openshiftBuildConfig).hashCode());
        String $routeDomain = this.getRouteDomain();
        result = result * 59 + ($routeDomain == null ? 43 : $routeDomain.hashCode());
        return result;
    }

    public static class ResourceConfigBuilder {
        private Map<String, String> env;
        private MetaDataConfig labels;
        private MetaDataConfig annotations;
        private ArrayList<VolumeConfig> volumes;
        private ArrayList<SecretConfig> secrets;
        private String controllerName;
        private ArrayList<ServiceConfig> services;
        private ArrayList<String> remotes;
        private ConfigMap configMap;
        private ProbeConfig liveness;
        private ProbeConfig readiness;
        private MetricsConfig metrics;
        private boolean containerPrivileged;
        private String imagePullPolicy;
        private ArrayList<String> ports$key;
        private ArrayList<Integer> ports$value;
        private int replicas;
        private String namespace;
        private String serviceAccount;
        private ArrayList<String> customResourceDefinitions;
        private ArrayList<ServiceAccountConfig> serviceAccounts;
        private ArrayList<IngressRule> ingressRules;
        private OpenshiftBuildConfig openshiftBuildConfig;
        private String routeDomain;

        ResourceConfigBuilder() {
        }

        public ResourceConfigBuilder env(Map<String, String> env) {
            this.env = env;
            return this;
        }

        public ResourceConfigBuilder labels(MetaDataConfig labels) {
            this.labels = labels;
            return this;
        }

        public ResourceConfigBuilder annotations(MetaDataConfig annotations) {
            this.annotations = annotations;
            return this;
        }

        public ResourceConfigBuilder volume(VolumeConfig volume) {
            if (this.volumes == null) {
                this.volumes = new ArrayList();
            }
            this.volumes.add(volume);
            return this;
        }

        public ResourceConfigBuilder volumes(Collection<? extends VolumeConfig> volumes) {
            if (volumes == null) {
                throw new NullPointerException("volumes cannot be null");
            }
            if (this.volumes == null) {
                this.volumes = new ArrayList();
            }
            this.volumes.addAll(volumes);
            return this;
        }

        public ResourceConfigBuilder clearVolumes() {
            if (this.volumes != null) {
                this.volumes.clear();
            }
            return this;
        }

        public ResourceConfigBuilder secret(SecretConfig secret) {
            if (this.secrets == null) {
                this.secrets = new ArrayList();
            }
            this.secrets.add(secret);
            return this;
        }

        public ResourceConfigBuilder secrets(Collection<? extends SecretConfig> secrets) {
            if (secrets == null) {
                throw new NullPointerException("secrets cannot be null");
            }
            if (this.secrets == null) {
                this.secrets = new ArrayList();
            }
            this.secrets.addAll(secrets);
            return this;
        }

        public ResourceConfigBuilder clearSecrets() {
            if (this.secrets != null) {
                this.secrets.clear();
            }
            return this;
        }

        public ResourceConfigBuilder controllerName(String controllerName) {
            this.controllerName = controllerName;
            return this;
        }

        public ResourceConfigBuilder service(ServiceConfig service) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.add(service);
            return this;
        }

        public ResourceConfigBuilder services(Collection<? extends ServiceConfig> services) {
            if (services == null) {
                throw new NullPointerException("services cannot be null");
            }
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.addAll(services);
            return this;
        }

        public ResourceConfigBuilder clearServices() {
            if (this.services != null) {
                this.services.clear();
            }
            return this;
        }

        public ResourceConfigBuilder remote(String remote) {
            if (this.remotes == null) {
                this.remotes = new ArrayList();
            }
            this.remotes.add(remote);
            return this;
        }

        public ResourceConfigBuilder remotes(Collection<? extends String> remotes) {
            if (remotes == null) {
                throw new NullPointerException("remotes cannot be null");
            }
            if (this.remotes == null) {
                this.remotes = new ArrayList();
            }
            this.remotes.addAll(remotes);
            return this;
        }

        public ResourceConfigBuilder clearRemotes() {
            if (this.remotes != null) {
                this.remotes.clear();
            }
            return this;
        }

        public ResourceConfigBuilder configMap(ConfigMap configMap) {
            this.configMap = configMap;
            return this;
        }

        public ResourceConfigBuilder liveness(ProbeConfig liveness) {
            this.liveness = liveness;
            return this;
        }

        public ResourceConfigBuilder readiness(ProbeConfig readiness) {
            this.readiness = readiness;
            return this;
        }

        public ResourceConfigBuilder metrics(MetricsConfig metrics) {
            this.metrics = metrics;
            return this;
        }

        public ResourceConfigBuilder containerPrivileged(boolean containerPrivileged) {
            this.containerPrivileged = containerPrivileged;
            return this;
        }

        public ResourceConfigBuilder imagePullPolicy(String imagePullPolicy) {
            this.imagePullPolicy = imagePullPolicy;
            return this;
        }

        public ResourceConfigBuilder port(String portKey, Integer portValue) {
            if (this.ports$key == null) {
                this.ports$key = new ArrayList();
                this.ports$value = new ArrayList();
            }
            this.ports$key.add(portKey);
            this.ports$value.add(portValue);
            return this;
        }

        public ResourceConfigBuilder ports(Map<? extends String, ? extends Integer> ports) {
            if (ports == null) {
                throw new NullPointerException("ports cannot be null");
            }
            if (this.ports$key == null) {
                this.ports$key = new ArrayList();
                this.ports$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Integer> $lombokEntry : ports.entrySet()) {
                this.ports$key.add($lombokEntry.getKey());
                this.ports$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ResourceConfigBuilder clearPorts() {
            if (this.ports$key != null) {
                this.ports$key.clear();
                this.ports$value.clear();
            }
            return this;
        }

        public ResourceConfigBuilder replicas(int replicas) {
            this.replicas = replicas;
            return this;
        }

        public ResourceConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ResourceConfigBuilder serviceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public ResourceConfigBuilder customResourceDefinition(String customResourceDefinition) {
            if (this.customResourceDefinitions == null) {
                this.customResourceDefinitions = new ArrayList();
            }
            this.customResourceDefinitions.add(customResourceDefinition);
            return this;
        }

        public ResourceConfigBuilder customResourceDefinitions(Collection<? extends String> customResourceDefinitions) {
            if (customResourceDefinitions == null) {
                throw new NullPointerException("customResourceDefinitions cannot be null");
            }
            if (this.customResourceDefinitions == null) {
                this.customResourceDefinitions = new ArrayList();
            }
            this.customResourceDefinitions.addAll(customResourceDefinitions);
            return this;
        }

        public ResourceConfigBuilder clearCustomResourceDefinitions() {
            if (this.customResourceDefinitions != null) {
                this.customResourceDefinitions.clear();
            }
            return this;
        }

        public ResourceConfigBuilder serviceAccount(ServiceAccountConfig serviceAccount) {
            if (this.serviceAccounts == null) {
                this.serviceAccounts = new ArrayList();
            }
            this.serviceAccounts.add(serviceAccount);
            return this;
        }

        public ResourceConfigBuilder serviceAccounts(Collection<? extends ServiceAccountConfig> serviceAccounts) {
            if (serviceAccounts == null) {
                throw new NullPointerException("serviceAccounts cannot be null");
            }
            if (this.serviceAccounts == null) {
                this.serviceAccounts = new ArrayList();
            }
            this.serviceAccounts.addAll(serviceAccounts);
            return this;
        }

        public ResourceConfigBuilder clearServiceAccounts() {
            if (this.serviceAccounts != null) {
                this.serviceAccounts.clear();
            }
            return this;
        }

        public ResourceConfigBuilder ingressRule(IngressRule ingressRule) {
            if (this.ingressRules == null) {
                this.ingressRules = new ArrayList();
            }
            this.ingressRules.add(ingressRule);
            return this;
        }

        public ResourceConfigBuilder ingressRules(Collection<? extends IngressRule> ingressRules) {
            if (ingressRules == null) {
                throw new NullPointerException("ingressRules cannot be null");
            }
            if (this.ingressRules == null) {
                this.ingressRules = new ArrayList();
            }
            this.ingressRules.addAll(ingressRules);
            return this;
        }

        public ResourceConfigBuilder clearIngressRules() {
            if (this.ingressRules != null) {
                this.ingressRules.clear();
            }
            return this;
        }

        public ResourceConfigBuilder openshiftBuildConfig(OpenshiftBuildConfig openshiftBuildConfig) {
            this.openshiftBuildConfig = openshiftBuildConfig;
            return this;
        }

        public ResourceConfigBuilder routeDomain(String routeDomain) {
            this.routeDomain = routeDomain;
            return this;
        }

        public ResourceConfig build() {
            List<IngressRule> ingressRules;
            List<ServiceAccountConfig> serviceAccounts;
            List<String> customResourceDefinitions;
            Map<Object, Object> ports;
            List<String> remotes;
            List<ServiceConfig> services;
            List<SecretConfig> secrets;
            List<VolumeConfig> volumes;
            switch (this.volumes == null ? 0 : this.volumes.size()) {
                case 0: {
                    volumes = Collections.emptyList();
                    break;
                }
                case 1: {
                    volumes = Collections.singletonList(this.volumes.get(0));
                    break;
                }
                default: {
                    volumes = Collections.unmodifiableList(new ArrayList<VolumeConfig>(this.volumes));
                }
            }
            switch (this.secrets == null ? 0 : this.secrets.size()) {
                case 0: {
                    secrets = Collections.emptyList();
                    break;
                }
                case 1: {
                    secrets = Collections.singletonList(this.secrets.get(0));
                    break;
                }
                default: {
                    secrets = Collections.unmodifiableList(new ArrayList<SecretConfig>(this.secrets));
                }
            }
            switch (this.services == null ? 0 : this.services.size()) {
                case 0: {
                    services = Collections.emptyList();
                    break;
                }
                case 1: {
                    services = Collections.singletonList(this.services.get(0));
                    break;
                }
                default: {
                    services = Collections.unmodifiableList(new ArrayList<ServiceConfig>(this.services));
                }
            }
            switch (this.remotes == null ? 0 : this.remotes.size()) {
                case 0: {
                    remotes = Collections.emptyList();
                    break;
                }
                case 1: {
                    remotes = Collections.singletonList(this.remotes.get(0));
                    break;
                }
                default: {
                    remotes = Collections.unmodifiableList(new ArrayList<String>(this.remotes));
                }
            }
            switch (this.ports$key == null ? 0 : this.ports$key.size()) {
                case 0: {
                    ports = Collections.emptyMap();
                    break;
                }
                case 1: {
                    ports = Collections.singletonMap(this.ports$key.get(0), this.ports$value.get(0));
                    break;
                }
                default: {
                    ports = new LinkedHashMap(this.ports$key.size() < 0x40000000 ? 1 + this.ports$key.size() + (this.ports$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.ports$key.size(); ++$i) {
                        ports.put(this.ports$key.get($i), this.ports$value.get($i));
                    }
                    ports = Collections.unmodifiableMap(ports);
                }
            }
            switch (this.customResourceDefinitions == null ? 0 : this.customResourceDefinitions.size()) {
                case 0: {
                    customResourceDefinitions = Collections.emptyList();
                    break;
                }
                case 1: {
                    customResourceDefinitions = Collections.singletonList(this.customResourceDefinitions.get(0));
                    break;
                }
                default: {
                    customResourceDefinitions = Collections.unmodifiableList(new ArrayList<String>(this.customResourceDefinitions));
                }
            }
            switch (this.serviceAccounts == null ? 0 : this.serviceAccounts.size()) {
                case 0: {
                    serviceAccounts = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceAccounts = Collections.singletonList(this.serviceAccounts.get(0));
                    break;
                }
                default: {
                    serviceAccounts = Collections.unmodifiableList(new ArrayList<ServiceAccountConfig>(this.serviceAccounts));
                }
            }
            switch (this.ingressRules == null ? 0 : this.ingressRules.size()) {
                case 0: {
                    ingressRules = Collections.emptyList();
                    break;
                }
                case 1: {
                    ingressRules = Collections.singletonList(this.ingressRules.get(0));
                    break;
                }
                default: {
                    ingressRules = Collections.unmodifiableList(new ArrayList<IngressRule>(this.ingressRules));
                }
            }
            return new ResourceConfig(this.env, this.labels, this.annotations, volumes, secrets, this.controllerName, services, remotes, this.configMap, this.liveness, this.readiness, this.metrics, this.containerPrivileged, this.imagePullPolicy, ports, this.replicas, this.namespace, this.serviceAccount, customResourceDefinitions, serviceAccounts, ingressRules, this.openshiftBuildConfig, this.routeDomain);
        }

        public String toString() {
            return "ResourceConfig.ResourceConfigBuilder(env=" + this.env + ", labels=" + this.labels + ", annotations=" + this.annotations + ", volumes=" + this.volumes + ", secrets=" + this.secrets + ", controllerName=" + this.controllerName + ", services=" + this.services + ", remotes=" + this.remotes + ", configMap=" + this.configMap + ", liveness=" + this.liveness + ", readiness=" + this.readiness + ", metrics=" + this.metrics + ", containerPrivileged=" + this.containerPrivileged + ", imagePullPolicy=" + this.imagePullPolicy + ", ports$key=" + this.ports$key + ", ports$value=" + this.ports$value + ", replicas=" + this.replicas + ", namespace=" + this.namespace + ", serviceAccount=" + this.serviceAccount + ", customResourceDefinitions=" + this.customResourceDefinitions + ", serviceAccounts=" + this.serviceAccounts + ", ingressRules=" + this.ingressRules + ", openshiftBuildConfig=" + this.openshiftBuildConfig + ", routeDomain=" + this.routeDomain + ")";
        }
    }
}

