/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jkube.kit.config.resource.ServiceProtocol;

public class ServiceConfig {
    private String name;
    private List<Port> ports;
    private boolean headless;
    private boolean expose;
    private String type;
    private boolean normalizePort;

    public static ServiceConfigBuilder builder() {
        return new ServiceConfigBuilder();
    }

    public ServiceConfigBuilder toBuilder() {
        ServiceConfigBuilder builder = new ServiceConfigBuilder().name(this.name).headless(this.headless).expose(this.expose).type(this.type).normalizePort(this.normalizePort);
        if (this.ports != null) {
            builder.ports(this.ports);
        }
        return builder;
    }

    public ServiceConfig(String name, List<Port> ports, boolean headless, boolean expose, String type, boolean normalizePort) {
        this.name = name;
        this.ports = ports;
        this.headless = headless;
        this.expose = expose;
        this.type = type;
        this.normalizePort = normalizePort;
    }

    public ServiceConfig() {
    }

    public String getName() {
        return this.name;
    }

    public List<Port> getPorts() {
        return this.ports;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public boolean isExpose() {
        return this.expose;
    }

    public String getType() {
        return this.type;
    }

    public boolean isNormalizePort() {
        return this.normalizePort;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceConfig)) {
            return false;
        }
        ServiceConfig other = (ServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Port> this$ports = this.getPorts();
        List<Port> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        if (this.isHeadless() != other.isHeadless()) {
            return false;
        }
        if (this.isExpose() != other.isExpose()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        return this.isNormalizePort() == other.isNormalizePort();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Port> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        result = result * 59 + (this.isHeadless() ? 79 : 97);
        result = result * 59 + (this.isExpose() ? 79 : 97);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + (this.isNormalizePort() ? 79 : 97);
        return result;
    }

    public static class ServiceConfigBuilder {
        private String name;
        private ArrayList<Port> ports;
        private boolean headless;
        private boolean expose;
        private String type;
        private boolean normalizePort;

        ServiceConfigBuilder() {
        }

        public ServiceConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ServiceConfigBuilder port(Port port) {
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.add(port);
            return this;
        }

        public ServiceConfigBuilder ports(Collection<? extends Port> ports) {
            if (ports == null) {
                throw new NullPointerException("ports cannot be null");
            }
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.addAll(ports);
            return this;
        }

        public ServiceConfigBuilder clearPorts() {
            if (this.ports != null) {
                this.ports.clear();
            }
            return this;
        }

        public ServiceConfigBuilder headless(boolean headless) {
            this.headless = headless;
            return this;
        }

        public ServiceConfigBuilder expose(boolean expose) {
            this.expose = expose;
            return this;
        }

        public ServiceConfigBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ServiceConfigBuilder normalizePort(boolean normalizePort) {
            this.normalizePort = normalizePort;
            return this;
        }

        public ServiceConfig build() {
            List<Port> ports;
            switch (this.ports == null ? 0 : this.ports.size()) {
                case 0: {
                    ports = Collections.emptyList();
                    break;
                }
                case 1: {
                    ports = Collections.singletonList(this.ports.get(0));
                    break;
                }
                default: {
                    ports = Collections.unmodifiableList(new ArrayList<Port>(this.ports));
                }
            }
            return new ServiceConfig(this.name, ports, this.headless, this.expose, this.type, this.normalizePort);
        }

        public String toString() {
            return "ServiceConfig.ServiceConfigBuilder(name=" + this.name + ", ports=" + this.ports + ", headless=" + this.headless + ", expose=" + this.expose + ", type=" + this.type + ", normalizePort=" + this.normalizePort + ")";
        }
    }

    public static class Port {
        private String protocol;
        private int port;
        private int targetPort;
        private Integer nodePort;
        private String name;

        public ServiceProtocol getProtocol() {
            return Optional.ofNullable(this.protocol).map(String::toUpperCase).map(ServiceProtocol::valueOf).orElse(null);
        }

        public static PortBuilder builder() {
            return new PortBuilder();
        }

        public PortBuilder toBuilder() {
            return new PortBuilder().protocol(this.protocol).port(this.port).targetPort(this.targetPort).nodePort(this.nodePort).name(this.name);
        }

        public Port(String protocol, int port, int targetPort, Integer nodePort, String name) {
            this.protocol = protocol;
            this.port = port;
            this.targetPort = targetPort;
            this.nodePort = nodePort;
            this.name = name;
        }

        public Port() {
        }

        public int getPort() {
            return this.port;
        }

        public int getTargetPort() {
            return this.targetPort;
        }

        public Integer getNodePort() {
            return this.nodePort;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Port)) {
                return false;
            }
            Port other = (Port)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ServiceProtocol this$protocol = this.getProtocol();
            ServiceProtocol other$protocol = other.getProtocol();
            if (this$protocol == null ? other$protocol != null : !((Object)((Object)this$protocol)).equals((Object)other$protocol)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getTargetPort() != other.getTargetPort()) {
                return false;
            }
            Integer this$nodePort = this.getNodePort();
            Integer other$nodePort = other.getNodePort();
            if (this$nodePort == null ? other$nodePort != null : !((Object)this$nodePort).equals(other$nodePort)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Port;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ServiceProtocol $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : ((Object)((Object)$protocol)).hashCode());
            result = result * 59 + this.getPort();
            result = result * 59 + this.getTargetPort();
            Integer $nodePort = this.getNodePort();
            result = result * 59 + ($nodePort == null ? 43 : ((Object)$nodePort).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public static class PortBuilder {
            private String protocol;
            private int port;
            private int targetPort;
            private Integer nodePort;
            private String name;

            PortBuilder() {
            }

            public PortBuilder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public PortBuilder port(int port) {
                this.port = port;
                return this;
            }

            public PortBuilder targetPort(int targetPort) {
                this.targetPort = targetPort;
                return this;
            }

            public PortBuilder nodePort(Integer nodePort) {
                this.nodePort = nodePort;
                return this;
            }

            public PortBuilder name(String name) {
                this.name = name;
                return this;
            }

            public Port build() {
                return new Port(this.protocol, this.port, this.targetPort, this.nodePort, this.name);
            }

            public String toString() {
                return "ServiceConfig.Port.PortBuilder(protocol=" + this.protocol + ", port=" + this.port + ", targetPort=" + this.targetPort + ", nodePort=" + this.nodePort + ", name=" + this.name + ")";
            }
        }
    }
}

