/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.resource;

import io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeFile;
import io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.kit.config.resource.VolumeConfig;

public enum VolumeType {
    HOST_PATH("hostPath"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewHostPath(config.getPath(), config.getHostPathType())).build();
        }
    }
    ,
    EMPTY_DIR("emptyDir"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            return ((VolumeBuilder)((VolumeFluent.EmptyDirNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewEmptyDir().withMedium(config.getMedium())).endEmptyDir()).build();
        }
    }
    ,
    GIT_REPO("gitRepo"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String repository = config.getRepository();
            String revision = config.getRevision();
            return ((VolumeBuilder)((VolumeFluent.GitRepoNested)((VolumeFluent.GitRepoNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewGitRepo().withRepository(repository)).withRevision(revision)).endGitRepo()).build();
        }
    }
    ,
    SECRET("secret"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String secretName = config.getSecretName();
            return ((VolumeBuilder)((VolumeFluent.SecretNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewSecret().withSecretName(secretName)).endSecret()).build();
        }
    }
    ,
    CONFIGMAP("configMap"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            return ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewConfigMap().withName(config.getConfigMapName())).withItems(config.getConfigMapItems())).endConfigMap()).build();
        }
    }
    ,
    NFS_PATH("nfsPath"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String path = config.getPath();
            String server = config.getServer();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewNfs(path, readOnly, server)).build();
        }
    }
    ,
    CGE_DISK("gcePdName"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String pdName = config.getPdName();
            String fsType = config.getFsType();
            Integer partition = config.getPartition();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewGcePersistentDisk(fsType, partition, pdName, readOnly)).build();
        }
    }
    ,
    GLUSTER_FS_PATH("glusterFsPath"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String path = config.getPath();
            String endpoints = config.getEndpoints();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewGlusterfs(path, endpoints, readOnly)).build();
        }
    }
    ,
    PERSISTENT_VOLUME_CLAIM("persistentVolumeClaim"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String claimRef = config.getClaimRef();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewPersistentVolumeClaim(claimRef, readOnly)).build();
        }
    }
    ,
    AWS_ELASTIC_BLOCK_STORE("awsElasticBlockStore"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String volumeId = config.getVolumeId();
            String fsType = config.getFsType();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeFluent.AwsElasticBlockStoreNested)((VolumeFluent.AwsElasticBlockStoreNested)((VolumeFluent.AwsElasticBlockStoreNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewAwsElasticBlockStore().withFsType(fsType)).withReadOnly(readOnly)).withVolumeID(volumeId)).endAwsElasticBlockStore()).build();
        }
    }
    ,
    AZURE_DISK("azureDisk"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String diskName = config.getDiskName();
            String diskURI = config.getDiskUri();
            String fsType = config.getFsType();
            String kind = config.getKind();
            String cachingMode = config.getCachingMode();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeFluent.AzureDiskNested)((VolumeFluent.AzureDiskNested)((VolumeFluent.AzureDiskNested)((VolumeFluent.AzureDiskNested)((VolumeFluent.AzureDiskNested)((VolumeFluent.AzureDiskNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewAzureDisk().withDiskName(diskName)).withDiskURI(diskURI)).withFsType(fsType)).withReadOnly(readOnly)).withCachingMode(cachingMode)).withKind(kind)).endAzureDisk()).build();
        }
    }
    ,
    AZURE_FILE("azureFile"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            Boolean readOnly = config.getReadOnly();
            String secretName = config.getSecretName();
            String shareName = config.getShareName();
            return ((VolumeBuilder)((VolumeFluent.AzureFileNested)((VolumeFluent.AzureFileNested)((VolumeFluent.AzureFileNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewAzureFile().withReadOnly(readOnly)).withSecretName(secretName)).withShareName(shareName)).endAzureFile()).build();
        }
    }
    ,
    CEPHFS("cephfs"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String path = config.getPath();
            Boolean readOnly = config.getReadOnly();
            String user = config.getUser();
            String secretFile = config.getSecretFile();
            String secretRef = config.getSecretRef();
            return ((VolumeBuilder)((VolumeFluent.CephfsNested)((CephFSVolumeSourceFluent.SecretRefNested)((VolumeFluent.CephfsNested)((VolumeFluent.CephfsNested)((VolumeFluent.CephfsNested)((VolumeFluent.CephfsNested)((VolumeFluent.CephfsNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewCephfs().withPath(path)).withMonitors(new String[0])).withUser(user)).withReadOnly(readOnly)).withSecretFile(secretFile)).withNewSecretRef().withName(secretRef)).endSecretRef()).endCephfs()).build();
        }
    }
    ,
    FIBRE_CHANNEL("fc"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            Boolean readOnly = config.getReadOnly();
            String fsType = config.getFsType();
            Integer lun = config.getLun();
            List<String> targetWWNs = config.getTargetWwns();
            return ((VolumeBuilder)((VolumeFluent.FcNested)((VolumeFluent.FcNested)((VolumeFluent.FcNested)((VolumeFluent.FcNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewFc().withWwids(targetWWNs)).withReadOnly(readOnly)).withFsType(fsType)).withLun(lun)).endFc()).build();
        }
    }
    ,
    FLOCKER("flocker"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String datasetName = config.getDatasetName();
            return ((VolumeBuilder)((VolumeFluent.FlockerNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewFlocker().withDatasetName(datasetName)).endFlocker()).build();
        }
    }
    ,
    ISCSI("iscsi"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            List<String> portals = config.getPortals();
            String targetPortal = config.getTargetPortal();
            String iqn = config.getIqn();
            Integer lun = config.getLun();
            String fsType = config.getFsType();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeFluent.IscsiNested)((VolumeFluent.IscsiNested)((VolumeFluent.IscsiNested)((VolumeFluent.IscsiNested)((VolumeFluent.IscsiNested)((VolumeFluent.IscsiNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewIscsi().withTargetPortal(targetPortal)).withPortals(portals)).withIqn(iqn)).withLun(lun)).withFsType(fsType)).withReadOnly(readOnly)).endIscsi()).build();
        }
    }
    ,
    PORTWORXVOLUME("portworxVolume"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String fsType = config.getFsType();
            String volumeId = config.getVolumeId();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeFluent.PortworxVolumeNested)((VolumeFluent.PortworxVolumeNested)((VolumeFluent.PortworxVolumeNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewPortworxVolume().withFsType(fsType)).withVolumeID(volumeId)).withReadOnly(readOnly)).endPortworxVolume()).build();
        }
    }
    ,
    QUOBYTE("quobyte"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String registry = config.getRegistry();
            String volume = config.getVolume();
            Boolean readOnly = config.getReadOnly();
            String user = config.getUser();
            String group = config.getGroup();
            return ((VolumeBuilder)((VolumeFluent.QuobyteNested)((VolumeFluent.QuobyteNested)((VolumeFluent.QuobyteNested)((VolumeFluent.QuobyteNested)((VolumeFluent.QuobyteNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewQuobyte().withRegistry(registry)).withVolume(volume)).withReadOnly(readOnly)).withUser(user)).withGroup(group)).endQuobyte()).build();
        }
    }
    ,
    RADOS_BLOCK_DEVICE("rbd"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            List<String> monitors = config.getMonitors();
            String pool = config.getPool();
            String fsType = config.getFsType();
            Boolean readOnly = config.getReadOnly();
            String user = config.getUser();
            String keyring = config.getKeyring();
            String image = config.getImage();
            return ((VolumeBuilder)((VolumeFluent.RbdNested)((VolumeFluent.RbdNested)((VolumeFluent.RbdNested)((VolumeFluent.RbdNested)((VolumeFluent.RbdNested)((VolumeFluent.RbdNested)((VolumeFluent.RbdNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewRbd().withMonitors(monitors)).withPool(pool)).withFsType(fsType)).withReadOnly(readOnly)).withUser(user)).withKeyring(keyring)).withImage(image)).endRbd()).build();
        }
    }
    ,
    SCALE_IO("scaleIO"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String gateway = config.getGateway();
            String system = config.getSystem();
            String protectionDomain = config.getProtectionDomain();
            String storagePool = config.getStoragePool();
            String volumeName = config.getVolumeName();
            String secretRef = config.getSecretRef();
            String fsType = config.getFsType();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeFluent.ScaleIONested)((VolumeFluent.ScaleIONested)((VolumeFluent.ScaleIONested)((VolumeFluent.ScaleIONested)((VolumeFluent.ScaleIONested)((ScaleIOVolumeSourceFluent.SecretRefNested)((VolumeFluent.ScaleIONested)((VolumeFluent.ScaleIONested)((VolumeFluent.ScaleIONested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewScaleIO().withFsType(fsType)).withGateway(gateway)).withNewReadOnly(readOnly.booleanValue())).withNewSecretRef().withName(secretRef)).endSecretRef()).withVolumeName(volumeName)).withStoragePool(storagePool)).withProtectionDomain(protectionDomain)).withSystem(system)).endScaleIO()).build();
        }
    }
    ,
    STORAGE_OS("storageOS"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String volumeName = config.getVolumeName();
            String fsType = config.getFsType();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeFluent.StorageosNested)((VolumeFluent.StorageosNested)((VolumeFluent.StorageosNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewStorageos().withFsType(fsType)).withVolumeName(volumeName)).withReadOnly(readOnly)).endStorageos()).build();
        }
    }
    ,
    VSPHERE_VOLUME("vsphereVolume"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            String path = config.getPath();
            String fsType = config.getFsType();
            return ((VolumeBuilder)((VolumeFluent.VsphereVolumeNested)((VolumeFluent.VsphereVolumeNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewVsphereVolume().withFsType(fsType)).withVolumePath(path)).endVsphereVolume()).build();
        }
    }
    ,
    DOWNWARD_API("downwardAPI"){

        @Override
        public Volume fromConfig(VolumeConfig config) {
            List<DownwardAPIVolumeFile> items = config.getItems();
            return ((VolumeBuilder)((VolumeFluent.DownwardAPINested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewDownwardAPI().withItems(items)).endDownwardAPI()).build();
        }
    };

    private final String type;
    private static final Map<String, VolumeType> VOLUME_TYPES;

    public abstract Volume fromConfig(VolumeConfig var1);

    private VolumeType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static VolumeType typeFor(String type) {
        return VOLUME_TYPES.get(type);
    }

    static {
        VOLUME_TYPES = new HashMap<String, VolumeType>();
        for (VolumeType volumeType : VolumeType.values()) {
            VOLUME_TYPES.put(volumeType.getType(), volumeType);
        }
    }
}

