/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.jkube.kit.build.service.docker.ServiceHub;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.service.ArtifactResolverService;
import org.eclipse.jkube.kit.common.service.MigrateService;
import org.eclipse.jkube.kit.common.util.LazyBuilder;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.config.access.ClusterAccess;
import org.eclipse.jkube.kit.config.access.ClusterConfiguration;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.config.service.ApplyService;
import org.eclipse.jkube.kit.config.service.BuildService;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.BuildServiceManager;
import org.eclipse.jkube.kit.config.service.DebugService;
import org.eclipse.jkube.kit.config.service.JKubeArtifactResolverService;
import org.eclipse.jkube.kit.config.service.PortForwardService;
import org.eclipse.jkube.kit.config.service.ResourceService;
import org.eclipse.jkube.kit.config.service.UndeployService;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesUndeployService;
import org.eclipse.jkube.kit.config.service.openshift.OpenshiftUndeployService;

public class JKubeServiceHub
implements Closeable {
    private JKubeConfiguration configuration;
    private ClusterAccess clusterAccess;
    private RuntimeMode platformMode;
    private KitLogger log;
    private ServiceHub dockerServiceHub;
    private BuildServiceConfig buildServiceConfig;
    private KubernetesClient client;
    private LazyBuilder<ArtifactResolverService> artifactResolverService;
    private LazyBuilder<BuildServiceManager> buildServiceManager;
    private LazyBuilder<ResourceService> resourceService;
    private LazyBuilder<PortForwardService> portForwardService;
    private LazyBuilder<ApplyService> applyService;
    private LazyBuilder<UndeployService> undeployService;
    private LazyBuilder<MigrateService> migrateService;
    private LazyBuilder<DebugService> debugService;
    private final boolean offline;

    public JKubeServiceHub(ClusterAccess clusterAccess, RuntimeMode platformMode, KitLogger log, ServiceHub dockerServiceHub, JKubeConfiguration configuration, BuildServiceConfig buildServiceConfig, LazyBuilder<ResourceService> resourceService, boolean offline) {
        this.clusterAccess = clusterAccess;
        this.platformMode = platformMode;
        this.log = log;
        this.dockerServiceHub = dockerServiceHub;
        this.configuration = configuration;
        this.buildServiceConfig = buildServiceConfig;
        this.resourceService = resourceService;
        this.offline = offline;
        this.init();
    }

    private void init() {
        Objects.requireNonNull(this.configuration, "JKubeKitConfiguration is required");
        Objects.requireNonNull(this.log, "log is a required parameter");
        Objects.requireNonNull(this.platformMode, "platformMode is a required parameter");
        this.initClusterAccessAndLazyBuilders();
        this.artifactResolverService = new LazyBuilder(() -> new JKubeArtifactResolverService(this.configuration.getProject()));
        this.migrateService = new LazyBuilder(() -> new MigrateService(this.getConfiguration().getBasedir(), this.log));
    }

    @Override
    public void close() {
        Optional.ofNullable(this.client).ifPresent(Client::close);
        Optional.ofNullable(this.dockerServiceHub).map(ServiceHub::getDockerAccess).ifPresent(DockerAccess::shutdown);
    }

    public RuntimeMode getRuntimeMode() {
        return this.platformMode;
    }

    public ArtifactResolverService getArtifactResolverService() {
        return (ArtifactResolverService)this.artifactResolverService.get();
    }

    public BuildService getBuildService() {
        return ((BuildServiceManager)this.buildServiceManager.get()).resolveBuildService();
    }

    public ResourceService getResourceService() {
        return (ResourceService)this.resourceService.get();
    }

    public ApplyService getApplyService() {
        return (ApplyService)this.applyService.get();
    }

    public UndeployService getUndeployService() {
        return (UndeployService)this.undeployService.get();
    }

    public MigrateService getMigrateService() {
        return (MigrateService)this.migrateService.get();
    }

    public PortForwardService getPortForwardService() {
        return (PortForwardService)this.portForwardService.get();
    }

    public DebugService getDebugService() {
        return (DebugService)this.debugService.get();
    }

    private void initClusterAccessAndLazyBuilders() {
        if (!this.offline) {
            if (this.clusterAccess == null) {
                this.clusterAccess = new ClusterAccess(this.log, ClusterConfiguration.from((Properties[])new Properties[]{System.getProperties(), this.configuration.getProject().getProperties()}).build());
            }
            this.client = this.clusterAccess.createDefaultClient();
        }
        this.applyService = new LazyBuilder(() -> {
            this.validateIfConnectedToCluster();
            return new ApplyService(this.client, this.log);
        });
        this.portForwardService = new LazyBuilder(() -> {
            this.validateIfConnectedToCluster();
            return new PortForwardService(this.client, this.log);
        });
        this.debugService = new LazyBuilder(() -> {
            this.validateIfConnectedToCluster();
            return new DebugService(this.log, this.client, (PortForwardService)this.portForwardService.get(), (ApplyService)this.applyService.get());
        });
        this.undeployService = new LazyBuilder(() -> {
            this.validateIfConnectedToCluster();
            if (this.platformMode == RuntimeMode.OPENSHIFT && OpenshiftHelper.isOpenShift((KubernetesClient)this.client)) {
                return new OpenshiftUndeployService(this, this.log);
            }
            return new KubernetesUndeployService(this, this.log);
        });
        this.buildServiceManager = new LazyBuilder(() -> new BuildServiceManager(this));
    }

    private void validateIfConnectedToCluster() {
        if (this.client == null) {
            throw new IllegalArgumentException("Connection to Cluster required. Please check if offline mode is set to false");
        }
    }

    public static JKubeServiceHubBuilder builder() {
        return new JKubeServiceHubBuilder();
    }

    public JKubeConfiguration getConfiguration() {
        return this.configuration;
    }

    public ClusterAccess getClusterAccess() {
        return this.clusterAccess;
    }

    public RuntimeMode getPlatformMode() {
        return this.platformMode;
    }

    public void setPlatformMode(RuntimeMode platformMode) {
        this.platformMode = platformMode;
    }

    public KitLogger getLog() {
        return this.log;
    }

    public ServiceHub getDockerServiceHub() {
        return this.dockerServiceHub;
    }

    public BuildServiceConfig getBuildServiceConfig() {
        return this.buildServiceConfig;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public static class JKubeServiceHubBuilder {
        private ClusterAccess clusterAccess;
        private RuntimeMode platformMode;
        private KitLogger log;
        private ServiceHub dockerServiceHub;
        private JKubeConfiguration configuration;
        private BuildServiceConfig buildServiceConfig;
        private LazyBuilder<ResourceService> resourceService;
        private boolean offline;

        JKubeServiceHubBuilder() {
        }

        public JKubeServiceHubBuilder clusterAccess(ClusterAccess clusterAccess) {
            this.clusterAccess = clusterAccess;
            return this;
        }

        public JKubeServiceHubBuilder platformMode(RuntimeMode platformMode) {
            this.platformMode = platformMode;
            return this;
        }

        public JKubeServiceHubBuilder log(KitLogger log) {
            this.log = log;
            return this;
        }

        public JKubeServiceHubBuilder dockerServiceHub(ServiceHub dockerServiceHub) {
            this.dockerServiceHub = dockerServiceHub;
            return this;
        }

        public JKubeServiceHubBuilder configuration(JKubeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public JKubeServiceHubBuilder buildServiceConfig(BuildServiceConfig buildServiceConfig) {
            this.buildServiceConfig = buildServiceConfig;
            return this;
        }

        public JKubeServiceHubBuilder resourceService(LazyBuilder<ResourceService> resourceService) {
            this.resourceService = resourceService;
            return this;
        }

        public JKubeServiceHubBuilder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public JKubeServiceHub build() {
            return new JKubeServiceHub(this.clusterAccess, this.platformMode, this.log, this.dockerServiceHub, this.configuration, this.buildServiceConfig, this.resourceService, this.offline);
        }

        public String toString() {
            return "JKubeServiceHub.JKubeServiceHubBuilder(clusterAccess=" + this.clusterAccess + ", platformMode=" + this.platformMode + ", log=" + this.log + ", dockerServiceHub=" + this.dockerServiceHub + ", configuration=" + this.configuration + ", buildServiceConfig=" + this.buildServiceConfig + ", resourceService=" + this.resourceService + ", offline=" + this.offline + ")";
        }
    }
}

