/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.kubernetes;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.TarImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jkube.kit.build.api.assembly.AssemblyManager;
import org.eclipse.jkube.kit.build.api.assembly.BuildDirs;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.service.docker.auth.AuthConfigFactory;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.RegistryConfig;
import org.eclipse.jkube.kit.common.archive.ArchiveCompression;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.service.BuildService;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.JKubeServiceException;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.service.jib.JibServiceUtil;

public class JibBuildService
implements BuildService {
    private static final String DOCKER_LOGIN_DEFAULT_REGISTRY = "https://index.docker.io/v1/";
    private static final List<String> DEFAULT_DOCKER_REGISTRIES = Arrays.asList("docker.io", "index.docker.io", "registry.hub.docker.com");
    private static final String PUSH_REGISTRY = "jkube.docker.push.registry";
    private final KitLogger log;
    private final BuildServiceConfig buildServiceConfig;
    private final JKubeConfiguration configuration;

    public JibBuildService(JKubeServiceHub jKubeServiceHub) {
        this.log = Objects.requireNonNull(jKubeServiceHub.getLog(), "Log is required");
        this.buildServiceConfig = Objects.requireNonNull(jKubeServiceHub.getBuildServiceConfig(), "BuildServiceConfig is required");
        this.configuration = Objects.requireNonNull(jKubeServiceHub.getConfiguration(), "JKubeConfiguration is required");
    }

    @Override
    public boolean isApplicable() {
        return this.buildServiceConfig.getJKubeBuildStrategy() == JKubeBuildStrategy.jib;
    }

    @Override
    public void build(ImageConfiguration imageConfig) throws JKubeServiceException {
        try {
            this.log.info("[[B]]JIB[[B]] image build started", new Object[0]);
            if (imageConfig.getBuildConfiguration().isDockerFileMode()) {
                throw new JKubeServiceException("Dockerfile mode is not supported with JIB build strategy");
            }
            JibBuildService.prependRegistry(imageConfig, this.configuration.getProperties().getProperty(PUSH_REGISTRY));
            BuildDirs buildDirs = new BuildDirs(imageConfig.getName(), this.configuration);
            Credential pullRegistryCredential = JibBuildService.getRegistryCredentials(this.configuration.getRegistryConfig(), false, imageConfig, this.log);
            JibContainerBuilder containerBuilder = JibServiceUtil.containerFromImageConfiguration((ImageConfiguration)imageConfig, (Credential)pullRegistryCredential);
            Map layers = AssemblyManager.getInstance().copyFilesToFinalTarballDirectory(this.configuration, buildDirs, AssemblyManager.getAssemblyConfiguration((BuildConfiguration)imageConfig.getBuildConfiguration(), (JKubeConfiguration)this.configuration));
            JibServiceUtil.layers((BuildDirs)buildDirs, (Map)layers).forEach(arg_0 -> ((JibContainerBuilder)containerBuilder).addFileEntriesLayer(arg_0));
            File dockerTarArchive = JibBuildService.getAssemblyTarArchive(imageConfig, this.configuration, this.log);
            JibServiceUtil.buildContainer((JibContainerBuilder)containerBuilder, (TarImage)TarImage.at((Path)dockerTarArchive.toPath()).named(imageConfig.getName()), (KitLogger)this.log);
            this.log.info(" %s successfully built", new Object[]{dockerTarArchive.getAbsolutePath()});
        }
        catch (Exception ex) {
            throw new JKubeServiceException("Error when building JIB image", ex);
        }
    }

    @Override
    public void push(Collection<ImageConfiguration> imageConfigs, int retries, RegistryConfig registryConfig, boolean skipTag) throws JKubeServiceException {
        try {
            for (ImageConfiguration imageConfiguration : imageConfigs) {
                JibBuildService.prependRegistry(imageConfiguration, registryConfig.getRegistry());
                this.log.info("This push refers to: %s", new Object[]{imageConfiguration.getName()});
                JibServiceUtil.jibPush((ImageConfiguration)imageConfiguration, (Credential)JibBuildService.getRegistryCredentials(registryConfig, true, imageConfiguration, this.log), (File)JibBuildService.getBuildTarArchive(imageConfiguration, this.configuration), (KitLogger)this.log);
            }
        }
        catch (Exception ex) {
            throw new JKubeServiceException("Error when push JIB image", ex);
        }
    }

    @Override
    public void postProcess() {
    }

    static ImageConfiguration prependRegistry(ImageConfiguration imageConfiguration, String registry) {
        ImageName imageName = new ImageName(imageConfiguration.getName());
        if (!imageName.hasRegistry() && registry != null) {
            imageConfiguration.setName(registry + "/" + imageConfiguration.getName());
            imageConfiguration.setRegistry(registry);
        }
        return imageConfiguration;
    }

    static File getAssemblyTarArchive(ImageConfiguration imageConfig, JKubeConfiguration configuration, KitLogger log) throws IOException {
        log.info("Preparing assembly files", new Object[0]);
        String targetImage = imageConfig.getName();
        return AssemblyManager.getInstance().createDockerTarArchive(targetImage, configuration, imageConfig.getBuildConfiguration(), log, null);
    }

    static Credential getRegistryCredentials(RegistryConfig registryConfig, boolean isPush, ImageConfiguration imageConfiguration, KitLogger log) throws IOException {
        String registry = isPush ? EnvUtil.firstRegistryOf((String[])new String[]{new ImageName(imageConfiguration.getName()).getRegistry(), imageConfiguration.getRegistry(), registryConfig.getRegistry()}) : EnvUtil.firstRegistryOf((String[])new String[]{new ImageName(JibServiceUtil.getBaseImage((ImageConfiguration)imageConfiguration)).getRegistry(), registryConfig.getRegistry()});
        if (registry == null || DEFAULT_DOCKER_REGISTRIES.contains(registry)) {
            registry = DOCKER_LOGIN_DEFAULT_REGISTRY;
        }
        AuthConfigFactory authConfigFactory = new AuthConfigFactory(log);
        AuthConfig standardAuthConfig = authConfigFactory.createAuthConfig(isPush, registryConfig.isSkipExtendedAuth(), registryConfig.getAuthConfig(), registryConfig.getSettings(), null, registry, registryConfig.getPasswordDecryptionMethod());
        Credential credentials = null;
        if (standardAuthConfig != null) {
            credentials = Credential.from((String)standardAuthConfig.getUsername(), (String)standardAuthConfig.getPassword());
        }
        return credentials;
    }

    static File getBuildTarArchive(ImageConfiguration imageConfiguration, JKubeConfiguration configuration) {
        BuildDirs buildDirs = new BuildDirs(imageConfiguration.getName(), configuration);
        return new File(buildDirs.getTemporaryRootDirectory(), "docker-build." + ArchiveCompression.none.getFileSuffix());
    }
}

