/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import java.util.Properties;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.enricher.handler.ContainerHandler;
import org.eclipse.jkube.kit.enricher.handler.DaemonSetHandler;
import org.eclipse.jkube.kit.enricher.handler.DeploymentConfigHandler;
import org.eclipse.jkube.kit.enricher.handler.DeploymentHandler;
import org.eclipse.jkube.kit.enricher.handler.JobHandler;
import org.eclipse.jkube.kit.enricher.handler.NamespaceHandler;
import org.eclipse.jkube.kit.enricher.handler.PodTemplateHandler;
import org.eclipse.jkube.kit.enricher.handler.ProbeHandler;
import org.eclipse.jkube.kit.enricher.handler.ProjectHandler;
import org.eclipse.jkube.kit.enricher.handler.ReplicaSetHandler;
import org.eclipse.jkube.kit.enricher.handler.ReplicationControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.ServiceHandler;
import org.eclipse.jkube.kit.enricher.handler.StatefulSetHandler;

public class HandlerHub {
    private final PodTemplateHandler podTemplateHandler;

    public HandlerHub(GroupArtifactVersion groupArtifactVersion, Properties configuration) {
        ProbeHandler probeHandler = new ProbeHandler();
        ContainerHandler containerHandler = new ContainerHandler(configuration, groupArtifactVersion, probeHandler);
        this.podTemplateHandler = new PodTemplateHandler(containerHandler);
    }

    public ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    public DeploymentHandler getDeploymentHandler() {
        return new DeploymentHandler(this.podTemplateHandler);
    }

    public DeploymentConfigHandler getDeploymentConfigHandler() {
        return new DeploymentConfigHandler(this.podTemplateHandler);
    }

    public ReplicaSetHandler getReplicaSetHandler() {
        return new ReplicaSetHandler(this.podTemplateHandler);
    }

    public ReplicationControllerHandler getReplicationControllerHandler() {
        return new ReplicationControllerHandler(this.podTemplateHandler);
    }

    public StatefulSetHandler getStatefulSetHandler() {
        return new StatefulSetHandler(this.podTemplateHandler);
    }

    public DaemonSetHandler getDaemonSetHandler() {
        return new DaemonSetHandler(this.podTemplateHandler);
    }

    public JobHandler getJobHandler() {
        return new JobHandler(this.podTemplateHandler);
    }

    public ProjectHandler getProjectHandler() {
        return new ProjectHandler();
    }

    public NamespaceHandler getNamespaceHandler() {
        return new NamespaceHandler();
    }
}

