/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.batch.v1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobSpec;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobSpecBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpec;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpec;
import io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecBuilder;
import java.util.List;
import java.util.Optional;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.ControllerResourceConfig;
import org.eclipse.jkube.kit.enricher.handler.ControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.PodTemplateHandler;

public class CronJobHandler
implements ControllerHandler<CronJob> {
    private static final String DEFAULT_JOB_RESTART_POLICY = "OnFailure";
    private final PodTemplateHandler podTemplateHandler;

    public CronJobHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    @Override
    public CronJob get(ControllerResourceConfig config, List<ImageConfiguration> images) {
        return ((CronJobBuilder)((CronJobBuilder)new CronJobBuilder().withMetadata(this.createCronJobMetadata(config))).withSpec(this.createCronJobSpec(config, images))).build();
    }

    @Override
    public PodTemplateSpec getPodTemplateSpec(ControllerResourceConfig config, List<ImageConfiguration> images) {
        return this.get(config, images).getSpec().getJobTemplate().getSpec().getTemplate();
    }

    @Override
    public PodTemplateSpec getPodTemplate(CronJob controller) {
        return controller.getSpec().getJobTemplate().getSpec().getTemplate();
    }

    @Override
    public void overrideReplicas(KubernetesListBuilder resources, int replicas) {
    }

    private ObjectMeta createCronJobMetadata(ControllerResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"controller name"))).build();
    }

    private CronJobSpec createCronJobSpec(ControllerResourceConfig config, List<ImageConfiguration> images) {
        return ((CronJobSpecBuilder)((CronJobSpecBuilder)new CronJobSpecBuilder().withSchedule(KubernetesHelper.validateCronJobSchedule((String)config.getSchedule()))).withJobTemplate(this.createJobTemplateSpec(config, images))).build();
    }

    private JobTemplateSpec createJobTemplateSpec(ControllerResourceConfig config, List<ImageConfiguration> images) {
        return ((JobTemplateSpecBuilder)new JobTemplateSpecBuilder().withSpec(this.createJobSpec(config, images))).build();
    }

    private JobSpec createJobSpec(ControllerResourceConfig config, List<ImageConfiguration> images) {
        return ((JobSpecBuilder)new JobSpecBuilder().withTemplate(this.podTemplateHandler.getPodTemplate(config, Optional.ofNullable(config.getRestartPolicy()).orElse(DEFAULT_JOB_RESTART_POLICY), images))).build();
    }
}

