/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder;
import java.util.List;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.handler.ControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.PodTemplateHandler;

public class DeploymentConfigHandler
implements ControllerHandler<DeploymentConfig> {
    private final PodTemplateHandler podTemplateHandler;

    DeploymentConfigHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    @Override
    public DeploymentConfig get(ResourceConfig config, List<ImageConfiguration> images) {
        return ((DeploymentConfigBuilder)((DeploymentConfigBuilder)new DeploymentConfigBuilder().withMetadata(this.createMetaData(config))).withSpec(this.createDeploymentConfigSpec(config, images))).build();
    }

    @Override
    public PodTemplateSpec getPodTemplateSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return this.get(config, images).getSpec().getTemplate();
    }

    @Override
    public void overrideReplicas(KubernetesListBuilder resources, final int replicas) {
        resources.accept(new Visitor[]{new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder builder) {
                ((DeploymentConfigFluent.SpecNested)builder.editOrNewSpec().withReplicas(Integer.valueOf(replicas))).endSpec();
            }
        }});
    }

    private ObjectMeta createMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"controller name"))).build();
    }

    private DeploymentConfigSpec createDeploymentConfigSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((DeploymentConfigSpecBuilder)((DeploymentConfigSpecBuilder)new DeploymentConfigSpecBuilder().withReplicas(config.getReplicas())).withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

